% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpar.R
\name{tpar}
\alias{tpar}
\title{Set or query graphical parameters}
\usage{
tpar(..., hook = FALSE)
}
\arguments{
\item{...}{arguments of the form \code{key = value}. This includes all of the
parameters typically supported by \code{\link[graphics]{par}}, as well as
the \code{tinyplot}-specific ones described in the 'Graphical Parameters'
section below.}

\item{hook}{Logical. If \code{TRUE}, base graphical parameters persist across
plots via a hook applied before each new plot (see \code{?setHook}).}
}
\value{
When parameters are set, their previous values are returned in an
invisible named list. Such a list can be passed as an argument to \code{tpar} to
restore the parameter values.

When just one parameter is queried, the value of that parameter is returned
as (atomic) vector. When two or more parameters are queried, their values
are returned in a list, with the list names giving the parameters.

Note the inconsistency: setting one parameter returns a list, but querying
one parameter returns a vector.
}
\description{
Extends \code{\link[graphics]{par}}, serving as a (near) drop-in
replacement for setting or querying graphical parameters. The key
differences is that, beyond supporting the standard group of R graphical
parameters in \code{\link[graphics]{par}}, \code{tpar} also supports additional
graphical parameters that are provided by \code{tinyplot}. Similar to
\code{\link[graphics]{par}}, parameters are set by passing appropriate
\code{key = value} argument pairs, and multiple parameters can be set or queried
at the same time.
}
\details{
The \code{tinyplot}-specific parameters are saved in an internal
environment called \code{.tpar} for performance and safety reasons. However,
they can also be set at package load time via \code{\link[base]{options}},
which may prove convenient for users that want to enable different default
behaviour at startup (e.g., through an \code{.Rprofile} file). These options all
take a \verb{tinyplot_*} prefix, e.g.
\code{options(tinyplot_grid = TRUE, tinyplot_facet.bg = "grey90")}.

For their part, any "base" graphical parameters are caught dynamically and
passed on to \code{\link[graphics]{par}} as appropriate. Technically, only
parameters that satisfy \code{par(..., no.readonly = TRUE)} are evaluated.

However, note the important distinction: \code{tpar} only evaluates parameters
from \code{\link[graphics]{par}} if they are passed \emph{explicitly} by the
user. This means that \code{tpar} should not be used to capture the (invisible)
state of a user's entire set of graphics parameters, i.e. \code{tpar()} !=
\code{par()}. If you want to capture the \emph{all} existing graphics settings, then
you should rather use \code{par()} instead.
}
\section{Additional Graphical Parameters}{

\itemize{
\item \code{adj.xlab}: Numeric value between 0 and 1 controlling the alignment of the x-axis label.
\item \code{adj.ylab}: Numeric value between 0 and 1 controlling the alignment of the y-axis label.
\item \code{cairo}: Logical indicating whether \code{\link[grDevices]{cairo_pdf}} should be used when writing plots to PDF. If \code{FALSE}, then \code{\link[grDevices]{pdf}} will be used instead, with implications for embedding (non-standard) fonts. Only used if \code{tinyplot(..., file = "<filename>.pdf")} is called. Defaults to the value of \code{capabilities("cairo")}.
\item \code{dynmar}: Logical indicating whether \code{tinyplot} should attempt dynamic adjustment of margins to reduce whitespace and/or account for spacing of text elements (e.g., long horizontal y-axis labels). Note that this parameter is tightly coupled to internal \code{tinythemes()} logic and should \emph{not} be adjusted manually unless you really know what you are doing or don't mind risking unintended consequences to your plot.
\item \code{facet.bg}: Character or integer specifying the facet background colour. If an integer, will correspond to the user's default colour palette (see \code{palette}). Passed to \code{rect}. Defaults to \code{NULL} (none).
\item \code{facet.border}: Character or integer specifying the facet border colour. If an integer, will correspond to the user's default colour palette (see \code{palette}). Passed to \code{rect}. Defaults to \code{NA} (none).
\item \code{facet.cex}: Expansion factor for facet titles. Defaults to \code{1}.
\item \code{facet.col}: Character or integer specifying the facet text colour. If an integer, will correspond to the user's default global colour palette (see \code{palette}). Defaults to \code{NULL}, which is equivalent to "black".
\item \code{facet.font}: An integer corresponding to the desired font face for facet titles. For most font families and graphics devices, one of four possible values: \code{1} (regular), \code{2} (bold), \code{3} (italic), or \code{4} (bold italic). Defaults to \code{NULL}, which is equivalent to \code{1} (i.e., regular).
\item \code{file.height}: Numeric specifying the height (in inches) of any plot that is written to disk using the \code{tinyplot(..., file = X)} argument. Defaults to \code{7}.
\item \code{file.res}: Numeric specifying the resolution (in dots per square inch) of any plot that is written to disk in bitmap format (i.e., PNG or JPEG) using the \code{tinyplot(..., file = X)} argument. Defaults to \code{300}.
\item \code{file.width}: Numeric specifying the width (in inches) of any plot that is written to disk using the \code{tinyplot(..., file = X)} argument. Defaults to \code{7}.
\item \code{fmar}: A numeric vector of form \code{c(b,l,t,r)} for controlling the (base) margin padding, in terms of lines, between the individual facets in a faceted plot. Defaults to \code{c(1,1,1,1)}. If more than three facets are detected, the \code{fmar} parameter is scaled by 0.75 to reduce excess whitespace. For 2x2 plots, the padding better matches the \code{cex} expansion logic of base graphics.
\item \code{grid.col}: Character or (integer) numeric that specifies the color of the panel grid lines. Defaults to \code{"lightgray"}.
\item \code{grid.lty}: Character or (integer) numeric that specifies the line type of the panel grid lines. Defaults to \code{"dotted"}.
\item \code{grid.lwd}: Non-negative numeric giving the line width of the panel grid lines. Defaults to \code{1}.
\item \code{grid}: Logical indicating whether a background panel grid should be added to plots automatically. Defaults to \code{NULL}, which is equivalent to \code{FALSE}.
\item \code{lmar}: A numeric vector of form \code{c(inner, outer)} that gives the margin padding, in terms of lines, around the automatic \code{tinyplot} legend. Defaults to \code{c(1.0, 0.1)}. The inner margin is the gap between the legend and the plot region, and the outer margin is the gap between the legend and the edge of the graphics device.
\item \code{palette.qualitative}: Palette for qualitative colors. See the \code{palette} argument in \code{?tinyplot}.
\item \code{palette.sequential}: Palette for sequential colors. See the \code{palette} argument in \code{?tinyplot}.
\item \code{ribbon.alpha}: Numeric factor in the range \verb{[0,1]} for modifying the opacity alpha of "ribbon" and "area" type plots. Default value is \code{0.2}.
}
}

\examples{
# Return a list of existing base and tinyplot graphic params
tpar("las", "pch", "facet.bg", "facet.cex", "grid")

# Simple facet plot with these default values
tinyplot(mpg ~ wt, data = mtcars, facet = ~am)

# Set params to something new. Similar to graphics::par(), note that we save
# the existing values at the same time by assigning to an object.
op = tpar(
  las       = 1,
  pch       = 2,
  facet.bg  = "grey90",
  facet.cex = 2,
  grid      = TRUE
)

# Re-plot with these new params
tinyplot(mpg ~ wt, data = mtcars, facet = ~am)

# Reset back to original values
tpar(op)

# Important: tpar() only evalutes parameters that have been passed explicitly
#   by the user. So it it should not be used to query and set (restore)
#   parameters that weren't explicitly requested, i.e. tpar() != par().

# Note: The tinyplot-specific parameters can also be be set via `options`
#   with a `tinyplot_*` prefix, which can be convenient for enabling
#   different default behaviour at startup time (e.g., via an .Rprofile
#   file). Example:
# options(tinyplot_grid = TRUE, tinyplot_facet.bg = "grey90")

}
\seealso{
\code{\link[graphics:par]{graphics::par}} which \code{tpar} builds on top of. \code{\link{get_saved_par}}
is a convenience function for retrieving graphical parameters at different
stages of a \code{tinyplot} call (and used for internal accounting purposes).
\code{\link{tinytheme}} allows users to easily set a group of graphics parameters
in a single function call, according to a variety of predefined themes.
}
