% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_vector_norm}
\alias{linalg_vector_norm}
\title{Computes a vector norm.}
\usage{
linalg_vector_norm(A, ord = 2, dim = NULL, keepdim = FALSE, dtype = NULL)
}
\arguments{
\item{A}{(Tensor): tensor, flattened by default, but this behavior can be
controlled using \code{dim}.}

\item{ord}{(int, float, inf, -inf, 'fro', 'nuc', optional): order of norm. Default: \code{2}}

\item{dim}{(int, \code{Tuple[int]}, optional): dimensions over which to compute
the vector or matrix norm. See above for the behavior when \code{dim=NULL}.
Default: \code{NULL}}

\item{keepdim}{(bool, optional): If set to \code{TRUE}, the reduced dimensions are retained
in the result as dimensions with size one. Default: \code{FALSE}}

\item{dtype}{dtype (\code{torch_dtype}, optional): If specified, the input tensor is cast to
\code{dtype} before performing the operation, and the returned tensor's type
will be \code{dtype}. Default: \code{NULL}}
}
\description{
If \code{A} is complex valued, it computes the norm of \code{A$abs()}
Supports input of float, double, cfloat and cdouble dtypes.
This function does not necessarily treat multidimensonal \code{A} as a batch of
vectors, instead:
}
\details{
\itemize{
\item If \code{dim=NULL}, \code{A} will be flattened before the norm is computed.
\item If \code{dim} is an \code{int} or a \code{tuple}, the norm will be computed over these dimensions
and the other dimensions will be treated as batch dimensions.
}

This behavior is for consistency with \code{\link[=linalg_norm]{linalg_norm()}}.

\code{ord} defines the norm that is computed. The following norms are
supported:\tabular{lll}{
   \code{ord} \tab norm for matrices \tab norm for vectors \cr
   \code{NULL} (default) \tab Frobenius norm \tab \code{2}-norm (see below) \cr
   \code{"fro"} \tab Frobenius norm \tab – not supported – \cr
   \code{"nuc"} \tab nuclear norm \tab – not supported – \cr
   \code{Inf} \tab \code{max(sum(abs(x), dim=2))} \tab \code{max(abs(x))} \cr
   \code{-Inf} \tab \code{min(sum(abs(x), dim=2))} \tab \code{min(abs(x))} \cr
   \code{0} \tab – not supported – \tab \code{sum(x != 0)} \cr
   \code{1} \tab \code{max(sum(abs(x), dim=1))} \tab as below \cr
   \code{-1} \tab \code{min(sum(abs(x), dim=1))} \tab as below \cr
   \code{2} \tab largest singular value \tab as below \cr
   \code{-2} \tab smallest singular value \tab as below \cr
   other \code{int} or \code{float} \tab – not supported – \tab \code{sum(abs(x)^{ord})^{(1 / ord)}} \cr
}
}
\examples{
if (torch_is_installed()) {
a <- torch_arange(0, 8, dtype = torch_float()) - 4
a
b <- a$reshape(c(3, 3))
b

linalg_vector_norm(a, ord = 3.5)
linalg_vector_norm(b, ord = 3.5)
}
}
\seealso{
Other linalg: 
\code{\link{linalg_cholesky}()},
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()}
}
\concept{linalg}
