% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twn_info.R
\name{twn_info}
\alias{twn_info}
\alias{twn_voorkeurnaam}
\alias{twn_parent}
\alias{twn_status}
\alias{twn_localname}
\alias{twn_taxonlevel}
\alias{twn_taxontype}
\title{Opzoeken van de TWN informatie}
\usage{
twn_voorkeurnaam(taxa)

twn_parent(taxa)

twn_status(taxa, code = TRUE)

twn_localname(taxa)

twn_taxonlevel(taxa)

twn_taxontype(taxa)
}
\arguments{
\item{taxa}{Een vector met taxonnamen.}

\item{code}{Logisch. Geeft aan of de code of de omschrijving wordt geretourneerd.}
}
\value{
Een vector met TWN-informatie. Taxonnamen die niet in de TWN worden
gevonden krijgen \code{NA}.
}
\description{
De \verb{twn_*} - functies zoeken informatie uit de TWN-lijst op.
}
\details{
Deze functies accepteren een vector met taxonnamen en retourneren de
betreffende informatie uit de TWN-lijst. Als de taxonnaam niet in de
TWN-lijst voorkomt retourneert de functie \code{NA}
\itemize{
\item \code{twn_voorkeurnaam}: Geeft de voorkeurnaam van het taxon. Als het al de
voorkeurnaam is wordt de originele naam teruggegeven.
\item \code{twn_parent}: Geeft de parent van het taxon.
\item \code{twn_status}: Geeft de status(code) van het taxon.
\item \code{twn_localname}: Geeft de Nederlandse naam van het taxon.
\item \code{twn_taxonlevel}: Geeft het taxonomische niveau van het taxon.
\item \code{twn_taxontype}: Geeft het taxontype van het taxon.
}
}
\note{
De TWN-lijst is niet altijd volledig consistent. Diverse taxa staan
meerdere malen in de lijst. In dat geval wordt het eerste resultaat met
de laagste statuscode geretourneerd.

NB sommige taxa hebben meer dan 1 taxontype. In dat geval zijn de
taxontypen gecombineerd in een string in alfabetische volgorde
gescheiden door een spaties.

Als een taxon niet de voorkeurnaam is dan ontbreekt er vaak informatie
zoals de parent van het taxon. De functie \code{twn_parent} zoekt in dat
geval de parent van de voorkeurnaam.
}
\examples{
taxa <- c("Bufo calamita", "Bufo")

twn_voorkeurnaam(taxa)
twn_parent(taxa)
twn_status(taxa)
twn_localname(taxa)
twn_taxonlevel(taxa)
twn_taxontype(taxa)

}
\seealso{
Deze functies werken op basis van de tabel \link{twn_lijst}
}
