% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_explode}
\alias{umx_explode}
\title{Explode a string (Like the php function \code{explode})}
\usage{
umx_explode(delimiter = character(), string)
}
\arguments{
\item{delimiter}{what to break the string on. Default is empty string ""}

\item{string}{an character string, e.g. "dog"}
}
\value{
\itemize{
\item a vector of strings, e.g. c("d", "o", "g")
}
}
\description{
Takes a string and returns an array of delimited strings (by default, each single character)
}
\examples{
umx_explode("", "dog") # "d" "o" "g"
umx_explode(" ", "cats and dogs") # [1] "cats" "and"  "dogs"
}
\references{
\itemize{
\item \url{https://tbates.github.io}, \url{https://www.php.net/manual/en/function.explode.php}
}
}
\seealso{
Other String Functions: 
\code{\link{umx}},
\code{\link{umx_explode_twin_names}()},
\code{\link{umx_grep}()},
\code{\link{umx_names}()},
\code{\link{umx_paste_names}()},
\code{\link{umx_rot}()},
\code{\link{umx_str_chars}()},
\code{\link{umx_str_from_object}()},
\code{\link{umx_trim}()}
}
\concept{String Functions}
