% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_cov}
\alias{umx_is_cov}
\title{umx_is_cov}
\usage{
umx_is_cov(data = NULL, boolean = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{dataframe to test}

\item{boolean}{whether to return the type ("cov") or a boolean (default = string)}

\item{verbose}{How much feedback to give (default = FALSE)}
}
\value{
- "raw", "cor", or "cov", (or if boolean, then T | F)
}
\description{
test if a data frame, matrix or mxData is type cov or cor, or is likely to be raw...
}
\examples{
df = cov(mtcars)
umx_is_cov(df)
df = cor(mtcars)
umx_is_cov(df)
umx_is_cov(mxData(df[1:3,1:3], type= "cov", numObs = 200))
umx_is_cov(df, boolean = TRUE)
umx_is_cov(mtcars, boolean = TRUE)
}
\references{
- <https://github.com/tbates/umx>
}
\seealso{
Other Test: 
\code{\link{umx_check}()},
\code{\link{umx_check_OS}()},
\code{\link{umx_check_model}()},
\code{\link{umx_check_names}()},
\code{\link{umx_check_parallel}()},
\code{\link{umx_has_CIs}()},
\code{\link{umx_has_been_run}()},
\code{\link{umx_has_means}()},
\code{\link{umx_has_square_brackets}()},
\code{\link{umx_is_MxData}()},
\code{\link{umx_is_MxMatrix}()},
\code{\link{umx_is_MxModel}()},
\code{\link{umx_is_RAM}()}
}
\concept{Test}
