% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vald-extractor-package.R
\docType{package}
\name{vald.extractor-package}
\alias{vald.extractor-package}
\alias{vald.extractor}
\title{vald.extractor: Robust Pipeline for 'VALD' 'ForceDecks' Data Extraction and Analysis}
\description{
Provides a robust and reproducible pipeline for extracting, cleaning, and analyzing athlete performance data generated by 'VALD' 'ForceDecks' systems. The package supports batch-oriented data processing for large datasets, standardized data transformation workflows, and visualization utilities for sports science research and performance monitoring. It is designed to facilitate reproducible analysis across multiple sports with comprehensive documentation and error handling.

The vald.extractor package extends the valdr package by providing a
fault-tolerant, production-ready pipeline for extracting, cleaning, and
visualizing VALD ForceDecks data across multiple sports. It implements
chunked batch processing to prevent timeout errors, OAuth2 authentication
for metadata enrichment, and automated sports taxonomy mapping.
}
\section{Main Functions}{


**Data Extraction:**
\itemize{
  \item \code{\link{fetch_vald_batch}}: Chunked trial extraction with fault tolerance
  \item \code{\link{fetch_vald_metadata}}: OAuth2 authentication for profiles and groups
}

**Data Cleaning:**
\itemize{
  \item \code{\link{standardize_vald_metadata}}: Unnest groups and create unified athlete records
  \item \code{\link{classify_sports}}: Automated sports taxonomy mapping
  \item \code{\link{patch_metadata}}: Fix missing demographics from external files
}

**Data Transformation:**
\itemize{
  \item \code{\link{split_by_test}}: Split by test type with suffix removal
}

**Analysis & Visualization:**
\itemize{
  \item \code{\link{summary_vald_metrics}}: Generate summary statistics
  \item \code{\link{plot_vald_trends}}: Longitudinal trend visualization
  \item \code{\link{plot_vald_compare}}: Cross-sectional group comparisons
}
}

\section{Key Features}{

\itemize{
  \item Fault-tolerant chunked extraction prevents API timeout errors
  \item Automated sports classification saves hours of manual categorization
  \item Generic programming with suffix removal enables DRY analysis code
  \item Publication-ready visualizations with professional themes
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/praveenmaths89/vald.extractor}
  \item Report bugs at \url{https://github.com/praveenmaths89/vald.extractor/issues}
}

}
\author{
\strong{Maintainer}: Praveen D Chougale \email{praveenmaths89@gmail.com}

Authors:
\itemize{
  \item Usha Anathakumar \email{usha@som.iitb.ac.in}
}

}
\keyword{internal}
