% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_combine.R
\name{vascr_combine}
\alias{vascr_combine}
\title{Combine ECIS data frames end to end}
\usage{
vascr_combine(..., resample = FALSE)
}
\arguments{
\item{...}{List of data frames to be combined}

\item{resample}{Automatically try and re sample the data set. Default is FALSE}
}
\value{
A single data frame containing all the data imported, automatically incremented by experiment
}
\description{
This function will combine ECIS data sets end to end. Preferential to use over a simple rbind command as it runs additional checks to ensure that data points are correctly generated
}
\examples{
#Make three fake experiments worth of data
experiment1.df = vascr_subset(growth.df, experiment = "1")
experiment2.df = vascr_subset(growth.df, experiment = "2")
experiment3.df = vascr_subset(growth.df, experiment = "3")

data = vascr_combine(experiment1.df, experiment2.df, experiment3.df)
head(data)


}
