% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scramble_variables_rowwise.R
\name{scramble_variables_rowwise}
\alias{scramble_variables_rowwise}
\title{Scramble values across multiple columns rowwise in a data frame}
\usage{
scramble_variables_rowwise(data, ...)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Columns to scramble using tidyselect semantics. All arguments are combined into
a single set. Each can be:
\itemize{
\item Bare column names (e.g., \code{var1, var2})
\item A tidyselect expression (e.g., \code{starts_with("day_")})
\item A character vector of column names (e.g., \code{c("var1", "var2")})
}
If \code{data} is already a grouped \code{dplyr} data frame, existing grouping
is ignored.}
}
\value{
A data frame with values scrambled rowwise within the selected columns.
}
\description{
For each row, shuffle values across the selected columns. All selections passed
via \code{...} are combined into a single set and scrambled together.
To scramble different variable groups separately, call the function multiple times.
}
\details{
Rowwise scrambling moves values between columns, so selected columns must be
type-compatible. This function requires all selected columns to have the same
class (or be an integer/double mix). For factors, the selected columns must
also have identical levels.
}
\examples{
df <- data.frame(
  day_1 = c(1, 4, 7),
  day_2 = c(2, 5, 8),
  day_3 = c(3, 6, 9),
  score_a = c(10, 40, 70),
  score_b = c(20, 50, 80),
  id = 1:3
)

set.seed(123)
# Scramble one set of variables
library(dplyr)
df |> scramble_variables_rowwise(starts_with("day_"))

# Using character vectors
df |> scramble_variables_rowwise(c("day_1", "day_2", "day_3"))

# Scramble multiple sets separately
df |>
  scramble_variables_rowwise(starts_with("day_")) |>
  scramble_variables_rowwise(c("score_a", "score_b"))

# Multiple selectors are combined into one set (values can move between day_* and score_*)
df |> scramble_variables_rowwise(starts_with("day_"), starts_with("score_"))

}
\seealso{
\code{\link{scramble_values}} for scrambling a single vector, and
\code{\link{scramble_variables}} for scrambling multiple variables.
}
\keyword{scramble}
