% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_legend_with_brackets.R
\name{plot_with_custom_legend}
\alias{plot_with_custom_legend}
\title{Add custom legend with brackets to a ggplot}
\usage{
plot_with_custom_legend(
  plot,
  labels,
  colors,
  comparisons = NULL,
  legend_x = 0.05,
  legend_y = 0.95,
  legend_width = 0.25,
  title = NULL
)
}
\arguments{
\item{plot}{A ggplot object}

\item{labels}{Character vector of group names (in order)}

\item{colors}{Character vector of colors matching the groups}

\item{comparisons}{Data frame with columns: group1, group2, label}

\item{legend_x}{X position (0-1)}

\item{legend_y}{Y position (0-1)}

\item{legend_width}{Width of legend}

\item{title}{Legend title}
}
\value{
A ggplot object (classes \code{"gg"} and \code{"ggplot"}) with the vbracket legend incorporated.
  The plot's default legend is typically suppressed and a custom vbracket legend showing statistical comparison brackets is added.
}
\description{
Remove ggplot2's legend and add a custom legend with brackets
}
\examples{
\donttest{
library(ggplot2)
data <- data.frame(x = 1:10, y = 1:10, group = rep(c("A", "B"), each = 5))
p <- ggplot(data, aes(x, y, color = group)) + geom_line()
comps <- add_bracket_comparisons(groups1 = "A", groups2 = "B", labels = "*")
plot_with_custom_legend(p, c("A", "B"), c("red", "blue"), comps)
}
}
