% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_waterfall}
\alias{v_waterfall}
\title{Create a Waterfall Chart}
\usage{
v_waterfall(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Waterfall Chart
}
\examples{

library(vchartr)

balance <- data.frame(
  desc = c("Starting Cash",
           "Sales", "Refunds", "Payouts", "Court Losses",
           "Court Wins", "Contracts", "End Cash"),
  amount = c(2000, 3400, -1100, -100, -6600, 3800, 1400, 2800)
)

vchart(balance) \%>\% 
  v_waterfall(aes(x = desc, y = amount))


# With total values and formatting
data.frame(
  x = c("Feb.4", "Feb.11", "Feb.20", "Feb.25", "Mar.4", 
        "Mar.11", "Mar.19", "Mar.26", "Apr.1", "Apr.8",
        "Apr.15", "Apr.22", "Apr.29", "May.6", "total"),
  total = c(TRUE, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, TRUE),
  y = c(45L, -5L, 2L, -2L, 2L, 2L, -2L, 1L, 1L, 1L, 2L, 1L, -2L, -1L, NA)
) \%>\% 
  vchart() \%>\% 
  v_waterfall(
    aes(x = x, y = y, total = total),
    stackLabel = list(
      valueType = "absolute",
      formatMethod = JS("text => text + '\%'")
    )
  ) \%>\% 
  v_specs_legend(visible = TRUE)
}
