% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colplot.R
\name{colplot}
\alias{colplot}
\title{Function to plot columns of data.frames}
\usage{
colplot(
  df,
  cols = names(df),
  xlab = "",
  ylab = "",
  xlim = c(1, nrow(df)),
  ylim = range(unlist(df[[cols]]), na.rm = TRUE),
  main = NULL,
  theme = "black",
  col = cptcity::cpt(pal = cptcity::find_cpt("pastel")[4], n = length(names(df))),
  type = "b",
  lwd = 2,
  pch = 1:ncol(df),
  familyfont = "",
  ...
)
}
\arguments{
\item{df}{data.frame.}

\item{cols}{Character, columns of data.frame.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the x axis, defaults to a description of x.}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{main}{Character, a main title for the plot, see also \code{\link{title}}.}

\item{theme}{Character; "black", "dark", "clean", "ink"}

\item{col}{Colors. Default are cptcity colour palette "kst_18_pastels"}

\item{type}{"p" for points, "l" for lines, "b" for both points and lines,
"c" for empty points joined by lines, "o" for overplotted points and
lines, "s" and "S" for stair steps and "h" for histogram-like vertical
lines. Finally, "n" does not produce any points or lines.}

\item{lwd}{a vector of line widths, see \code{\link{par}}.}

\item{pch}{plotting ‘character’, i.e., symbol to use.}

\item{familyfont}{"Character" to specify font, default is"", options "serif",
"sans", "mono" or more according device}

\item{...}{plot arguments}
}
\value{
a nice plot
}
\description{
\code{\link{colplot}} plots columns of data.frame
}
\note{
This plot shows values > 0 by default. To plot all values, use all_values = TRUE
}
\examples{
\dontrun{
a <- ef_cetesb("CO", c("PC_G", "PC_FE", "PC_FG", "PC_E"), agemax = 20)
colplot(df = a, ylab = "CO [g/km]", theme = "dark", type = "b")
colplot(df = a, ylab = "CO [g/km]", theme = "dark", pch = NULL, type = "b")
colplot(df = a, ylab = "CO [g/km]", theme = "clean", type = "b")
colplot(df = a, ylab = "CO [g/km]", theme = "clean", pch = NULL, type = "b")
#colplot(df = a, cols = "PC_FG", main = "EF", ylab = "CO [g/km]")
#colplot(df = a, ylab = "CO [g/km]", theme = "clean")
}
}
\seealso{
\code{\link{par}}

Other helpers: 
\code{\link{dmonth}()},
\code{\link{to_latex}()}
}
\concept{helpers}
