% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_helpers.R
\name{.validate_time_components}
\alias{.validate_time_components}
\title{Multi-column time input path
Validate time components and build Date safely}
\usage{
.validate_time_components(
  y,
  m = NULL,
  d = NULL,
  doy = NULL,
  h = NULL,
  mode = c("ymd", "ydoy"),
  time_api_resolved = c("daily", "hourly"),
  time_cols = character(),
  max_examples = 5L
)
}
\arguments{
\item{y, m, d}{Integer-ish vectors (for mode="ymd").}

\item{doy}{Integer-ish vector (for mode="ydoy").}

\item{h}{Optional integer-ish vector.}

\item{mode}{"ymd" or "ydoy"}

\item{time_api_resolved}{"hourly" or "daily" (for hourly requirement checks)}

\item{time_cols}{Character vector of user-specified columns for error context.}

\item{max_examples}{How many bad examples to show in error messages.}
}
\value{
A list with \code{date} (Date) and \code{hour} (integer, possibly NA if missing and not allowed).
}
\description{
Multi-column time input path
Validate time components and build Date safely
}
\keyword{internal}
