% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_multidirectional_hillshade}
\alias{wbt_multidirectional_hillshade}
\title{Multidirectional hillshade}
\usage{
wbt_multidirectional_hillshade(
  dem,
  output,
  altitude = 45,
  zfactor = NULL,
  full_mode = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{altitude}{Illumination source altitude in degrees.}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{full_mode}{Optional flag indicating whether to use full 360-degrees of illumination sources.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates a multi-direction hillshade raster from an input DEM.
}
\keyword{GeomorphometricAnalysis}
