% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectUniform}
\alias{SelectUniform}
\title{Selection with uniform probability.}
\usage{
SelectUniform(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectUniform()} implements selection
             by choosing a gene with equal probability.
}
\details{
This selection function is useful:
             \enumerate{
             \item
             To specify mating behavior in crossover operators.
             \item
             For computer experiments without selection pressure.
             \item 
             For computing random search solutions as a benchmark.
             }
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectUniform(fit, NewlFselectGenes()) 
SelectUniform(fit, NewlFselectGenes(), length(fit)) 
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()}
}
\concept{Selection Functions}
