% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlr_numeric.R
\name{xlr_numeric}
\alias{xlr_numeric}
\alias{is_xlr_numeric}
\alias{as_xlr_numeric}
\title{\code{xlr_numeric} vector}
\usage{
xlr_numeric(
  x = numeric(),
  dp = 2L,
  scientific = FALSE,
  style = xlr_format_numeric()
)

is_xlr_numeric(x)

as_xlr_numeric(x, dp = 0L, scientific = FALSE, style = xlr_format_numeric())
}
\arguments{
\item{x}{\itemize{
\item For \code{xlr_numeric()}: A numeric vector
\item For \code{is_xlr_numeric()}: An object to test
\item For \code{as_xlr_numeric()} : a vector
}}

\item{dp}{the number of decimal places to print}

\item{scientific}{logical. Whether to format the numeric using scientific notation.}

\item{style}{Additional styling options for the vector. See \link{xlr_format_numeric} for more details.}
}
\value{
An S3 vector of class \code{xlr_numeric}
}
\description{
This creates an numeric vector that will be printed neatly and can easily be
exported to \code{Excel} using it's native format. You can
convert a vector back to its base type with \code{\link[=as_base_r]{as_base_r()}}.
}
\details{
Internally, \code{xlr_numeric} uses \code{vec_cast} to convert numeric types
to integers. Anything that \code{vec_cast} can handle so can \code{xlr_numeric}. Read
more about casting at \link[vctrs]{vec_cast}.
}
\examples{
library(xlr)
# Create a variable to represent a double with two decimal places
# The decimal places must be a positive integer
x <- xlr_numeric(2.1134,dp = 2)
# This will print nicely
x
# You can change the styling, which affects how it looks when we print it
x <- xlr_numeric(x, dp = 3L, style = xlr_format(font_size = 9, font_colour = "red"))
x
# We can also define a vector of doubles
y <- xlr_numeric(c(22.1055,1.3333333,3.1234567), dp = 2)
y
# You can convert existing data to a double using dplyr verbs
df <- data.frame(col_1 = c(2,3.2,1.33,4.43251))
df |>
  dplyr::mutate(col_pct = as_xlr_numeric(col_1))
# You can use as_xlr_numeric to convert a string in a double
df <- data.frame(col_str = c("12.22","12.34567","100"))
# now we can convert the string to a double(), internally it uses the same
# logic as as.double()
df |>
  dplyr::mutate(col_double = as_xlr_numeric(col_str,2))
}
\seealso{
\code{\link[=xlr_percent]{xlr_percent()}}, \code{\link[=xlr_integer]{xlr_integer()}}, \code{\link[=xlr_vector]{xlr_vector()}}, \code{\link[=as_base_r]{as_base_r()}}
}
