% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{z22_pivot_longer}
\alias{z22_pivot_longer}
\title{Cast feature grid to a long table}
\usage{
z22_pivot_longer(.data, feature, lang = c("english", "german"))
}
\arguments{
\item{.data}{Output of \code{\link{z22_data}}.}

\item{feature}{A grid feature that is represented by \code{.data}.}

\item{lang}{Specifies the language of the output description. Can be
either \code{"english"} (default) or \code{"german"}. Note that the
English descriptions are only ad-hoc translations based off the German
originals.}
}
\value{
A dataframe containing the columns \code{category}, \code{value},
\code{x} and \code{y}. All non-category columns are preserved.
}
\description{
Helper function to convert the output of \code{\link{z22_data}} to a
long table. This can be useful for plotting or other data wrangling tasks.

Note that pivoting can quickly become expensive for larger 100m grids.
}
\details{
Note that all columns starting with \code{"cat_*"} are automatically used
for pivoting.
}
\examples{
\dontshow{if (arrow::codec_is_available("zstd")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{# get feature grid
age <- z22_data("age_short", res = "10km")

# pivot to a long table
z22_pivot_longer(age, feature = "age_short")}
\dontshow{\}) # examplesIf}
}
