% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-kansuji.R
\name{label_kansuji}
\alias{label_kansuji}
\alias{label_kansuji_suffix}
\title{Label numbers in Kansuji format}
\usage{
label_kansuji(
  unit = NULL,
  sep = "",
  prefix = "",
  big.mark = "",
  number = c("arabic", "kansuji"),
  ...
)

label_kansuji_suffix(
  accuracy = 1,
  unit = NULL,
  sep = NULL,
  prefix = "",
  big.mark = "",
  significant.digits = FALSE,
  ...
)
}
\arguments{
\item{unit}{Optional units specifier.}

\item{sep}{Separator between number and Kansuji unit.}

\item{prefix}{Symbols to display before value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{number}{If Number is arabic, it will return a mixture of Arabic and the
Kansuji Myriad Scale; if Kansuji, it will return only Kansuji numerals.}

\item{...}{Other arguments passed on to \code{\link[base:formatc]{base::prettyNum()}}, \code{\link[scales:label_number]{scales::label_number()}} or
\code{\link[arabic2kansuji:arabic2kansuji]{arabic2kansuji::arabic2kansuji_all()}}.}

\item{accuracy}{A number to round to. Use (e.g.) 0.01 to show 2 decimal
places of precision.}

\item{significant.digits}{Determines whether or not the value of accurary is
valid as a significant figure with a decimal point. The default is FALSE, in
which case if accurary is 2 and the value is 1.10, 1.1 will be displayed,
but if TRUE and installed \code{{scales}} package, 1.10 will be displayed.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function
that takes a vector x and returns a character vector of length(x) giving a
label for each input value.
}
\description{
Automatically scales and labels with the Kansuji Myriad Scale (e.g. "Man",
"Oku", etc).
Use \code{\link[=label_kansuji]{label_kansuji()}} converts the label value to either Kansuji value or a
mixture of Arabic numerals and the Kansuji Scales for ten thousands,
billions, and ten quadrillions.
Use \code{\link[=label_kansuji_suffix]{label_kansuji_suffix()}} converts the label value to an Arabic numeral
followed by the Kansuji Scale with the suffix.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library("scales")
demo_continuous(c(1, 1e9), label = label_kansuji())
demo_continuous(c(1, 1e9), label = label_kansuji_suffix())
}\if{html}{\out{</div>}}
}

