% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_sim.R
\name{simulate}
\alias{simulate}
\alias{simulate.bekk}
\alias{simulate.bekka}
\alias{simulate.dbekk}
\alias{simulate.dbekka}
\alias{simulate.sbekk}
\alias{simulate.sbekka}
\title{Simulating BEKK models}
\usage{
\method{simulate}{bekk}(object, nsim, ...)

\method{simulate}{bekka}(object, ..., nsim)

\method{simulate}{dbekk}(object, ..., nsim)

\method{simulate}{dbekka}(object, ..., nsim)

\method{simulate}{sbekk}(object, ..., nsim)

\method{simulate}{sbekka}(object, ..., nsim)
}
\arguments{
\item{object}{A spec object of class "bekkSpec" from the function \link{bekk_spec} or a fitted bekk model of class "bekkFit" from the \link{bekk_fit} function}

\item{nsim}{Number of observations of the simulated sample}

\item{...}{Further parameters to be passed on to the function.}
}
\value{
Returns a simulated time series S3 class object using the parameters of passed "bekkSpec" or "bekkFit".
}
\description{
Method for simulating a N-dimensional BEKK model.
}
\examples{
\donttest{

# simulate a BEKK with estimated parameter
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds)

x2 <- simulate(x1, nsim = 3000)

plot(x2)

}

}
