% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\title{Posterior Predictive Distribution}
\usage{
posterior_predict(object, iter = 1000, progress = TRUE)
}
\arguments{
\item{object}{An object of class \code{estimate} or \code{explore}}

\item{iter}{Numeric. Number of samples from the predictive distribution}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE})}
}
\value{
A 3D array containing the predicted datasets
}
\description{
Draw samples from the posterior predictive distribution.
}
\note{
Currently only implemented for \code{type = "mixed"}, \code{type = "ordinal"},
      and \code{type = "binary"}. Note the term mixed is confusing, in that it can
      be used with only, say, ordinal data. In this case, reestimate the model with \code{type = "mixed"}
      until all data types are supported.
}
\examples{
\donttest{
Y <- gss

fit <- estimate(as.matrix(Y),
                impute = TRUE,
               iter = 150, type = "mixed")

yrep <- posterior_predict(fit, iter = 100)
}
}
