% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.explore.R
\name{summary.select.explore}
\alias{summary.select.explore}
\title{Summary Method for \code{select.explore} Objects}
\usage{
\method{summary}{select.explore}(object, col_names = TRUE, ...)
}
\arguments{
\item{object}{object of class \code{select.explore}.}

\item{col_names}{Logical.}

\item{...}{Currently ignored.}
}
\value{
a data frame including the posterior mean, standard deviation,
and posterior hypothesis probabilities for each relation.
}
\description{
Summary Method for \code{select.explore} Objects
}
\examples{
\donttest{
#  data
Y <- bfi[,1:10]

# fit model
fit <- explore(Y, iter = 250,
               progress = FALSE)

# edge set
E <- select(fit,
            alternative = "exhaustive")

summary(E)

}
}
