% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_2Dimage.R
\name{sim_2Dimage}
\alias{sim_2Dimage}
\title{Simulate image data using ICA}
\usage{
sim_2Dimage(length = 20, n = 50, sigma = 0.002, smooth = 6)
}
\arguments{
\item{length}{The length of the image.}

\item{n}{sample size.}

\item{sigma}{variance of the noise.}

\item{smooth}{smoothness of the latent components.}
}
\value{
List that contains the following terms:
\describe{
  \item{X}{Data matrix with n rows (sample) and p columns (pixel).}
  \item{coords}{Cordinate matrix with p rows (pixel) and d columns (dimension)}
  \item{S}{Latent components.}
  \item{A}{Mixing coefficent matrix.}
  \item{snr}{Signal-to-noise ratio.}
}
}
\description{
The function simulates image data using a probabilistic ICA model
whose latent components have specific spatial patterns.
}
\details{
The observations are generated using probabilistic ICA:
\deqn{  X_i(v) = \sum_{j=1}^q A_{i,j} S_j(v) + \epsilon_i(v) , }
where \eqn{S_j, j=1,...,q} are the latent components, \eqn{A_{i,j}} is
the mixing coeffecient and \eqn{\epsilon_i} is the noise term.
Specifically, the number of components in this function is \eqn{q = 3},
with each of them being a specific geometric shape. The mixing coefficient matrix
is generated with a von Mises-Fisher distribution with the concentration parameter
being zero, which means it is uniformly distributed on the sphere. \eqn{\epsilon_i}
is a i.i.d. Gaussian noise term with 0 mean and user-specified variance.
}
\examples{
sim = sim_2Dimage(length = 30, sigma = 5e-4, n = 30, smooth = 6)

}
