% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.bound.R
\name{fisher.bound}
\alias{fisher.bound}
\title{Calculate Rejection Boundary for Fisher's Exact Test}
\usage{
fisher.bound(pc, nc, nt, alpha = 0.1)
}
\arguments{
\item{pc}{A scalar numeric. The response rate for the control arm.}

\item{nc}{A scalar integer. The number of subjects in the control arm.}

\item{nt}{A scalar integer. The number of subjects in the experimental arm.}

\item{alpha}{A scalar numeric. The one-sided p-value threshold for
statistical significance. Default is 0.1.}
}
\value{
A list containing the following components:
\describe{
\item{M}{The 2x2 contingency table at the boundary.}
\item{p}{The p-value corresponding to the boundary.}
\item{rc}{The number of responders in the control arm, calculated as \code{round(nc * pc)}.}
\item{nc}{The sample size of the control arm.}
\item{rt}{The smallest number of responders in the experimental arm that
achieves a p-value <= \code{alpha}.}
\item{nt}{The sample size of the experimental arm.}
\item{delta}{The minimum detectable difference in response rates (\code{rt/nt - rc/nc}).}
}
}
\description{
For a given control group response rate and sample sizes, this function
finds the smallest number of responders in the experimental arm (\code{rt}) that
achieves statistical significance based on a one-sided Fisher's exact test.
}
\examples{
fisher.bound(pc=0.3, nc=40, nt=40, alpha=0.1)

}
