% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{visualize_stripe_patterns}
\alias{visualize_stripe_patterns}
\title{Visualize Stripe Pattern Simulation Results}
\usage{
visualize_stripe_patterns(
  sim_data,
  gap_seq,
  width_seq,
  theta_seq,
  bg_color = "grey",
  signal1_color = "#1f6f8b",
  signal2_color = "#e67e22",
  overlap_color = "#7a4dbf",
  show_title = TRUE
)
}
\arguments{
\item{sim_data}{Output from simulate_stripe_patterns function}

\item{gap_seq}{Vector of gap values used in simulation}

\item{width_seq}{Vector of width values used in simulation}

\item{theta_seq}{Vector of theta (rotation angle) values used in simulation}

\item{bg_color}{Background color for plots (default: "grey")}

\item{signal1_color}{Color for signal 1 (default: "#1f6f8b")}

\item{signal2_color}{Color for signal 2 (default: "#e67e22")}

\item{overlap_color}{Color for overlapping regions (default: "#7a4dbf")}

\item{show_title}{Logical; if TRUE (default), add titles to plots with parameter values}
}
\value{
Combined ggplot object with all pattern visualizations
}
\description{
Create visualization plots for stripe pattern simulation results
}
\examples{
\donttest{
# Generate and visualize patterns
sim_data <- simulate_stripe_patterns(
  grid_size = 80,
  gap_seq = c(10, 20),
  width_seq = c(5, 10, 20),
  theta_seq = c(0, 30, 60)
)
plot_grid <- visualize_stripe_patterns(sim_data, 
                                       gap_seq = c(10, 20),
                                       width_seq = c(5, 10, 20),
                                       theta_seq = c(0, 30, 60))
print(plot_grid)
}
}
