% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCMnet_diagnostics_traceplot.R
\name{CCM_traceplot}
\alias{CCM_traceplot}
\title{Plot MCMC Trace for sample_ccm}
\usage{
CCM_traceplot(object, stats = NULL, ...)
}
\arguments{
\item{object}{A \code{ccm_sample} object.}

\item{stats}{string. Which statistic to plot.}

\item{...}{Additional arguments passed to \code{plot()}.}
}
\value{
A trace plot for the selected MCMC chain.
}
\description{
\code{CCM_traceplot} produces a trace plot of the MCMC samples from
\code{sample_ccm}. This is used to diagnose convergence and mixing.
}
\examples{
ccm_sample <- sample_ccm(
  network_stats = list("edges"),
  prob_distr = list("poisson"),
  prob_distr_params = list(list(350)),
  population = 50 
)
CCM_traceplot(ccm_sample, stats = "edges")

}
