% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_clog.R
\name{residuals_clog}
\alias{residuals_clog}
\title{Model Diagnostic for Conditional Logistic Regression}
\usage{
residuals_clog(model, strata, y, plot = TRUE)
}
\arguments{
\item{model}{A fitted conditional logistic regression model of class \code{clogit}.}

\item{strata}{A vector of the strata (matching variables) that defines the pairs in the matched case-control design.}

\item{y}{A vector of the binary outcome variable (case-control indicator, where 1 represents the case and 0 represents the control).}

\item{plot}{A logical value indicating whether diagnostic plots should be generated. Defaults to TRUE.}
}
\value{
A list containing:
\item{data.results}{A data frame with the calculated residuals, leverage, and other diagnostic measures for each observation.}
\item{leverage}{A ggplot object displaying leverage vs. estimated probability.}
\item{change.Pearsonchi}{A ggplot object displaying the change in Pearson chi-squared vs. estimated probability.}
\item{cooks}{A ggplot object displaying Cook's distance vs. estimated probability.}
\item{m.Pearsonchi}{A ggplot object displaying the total pairwise change in Pearson chi-squared.}
\item{mcooks}{A ggplot object displaying the total pairwise change in Cook's distance.}
}
\description{
This function computes various diagnostic measures for a conditional logistic regression model,
including Pearson residuals, leverage, standardized Pearson residuals, delta chi, and delta beta values.
Additionally, it generates plots to visualize these diagnostics, helping to assess the model's fit and
identify potential influential data points.
This function assumes that the \code{strata} and \code{y} vectors are provided in the same order as they were used
when fitting the model with the \code{clogit} function.
}
\details{
The diagnostic measures are calculated based on the formulas provided by Hosmer et al. (2013).
The following measures are computed:
\itemize{
\item Pearson residuals
\item Standardized Pearson residuals
\item Leverage
\item Delta statistics: Delta beta (change in Cook's distance) and Delta chi (change in Pearson chi-squared)
}

Additionally, the function generates the following plots:
\itemize{
\item Leverage vs. Estimated Probability
\item Change in Pearson chi-squared vs. Estimated Probability
\item Cook's Distance vs. Estimated Probability
\item Change in Pearson chi-squared and Change in Cook's Distance vs Pair ID
}
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 7

# Convert 'fracture' to binary (0 = No, 1 = Yes)
glow11m$fracture <- ifelse(glow11m$fracture == "Yes", 1, 0)

# Load required package
library(survival)

# Fit a conditional logistic regression model
mod7.3 <- clogit(
  fracture ~ weight + bmi + priorfrac + momfrac + armassist + strata(pair),
  data = glow11m)

# Run diagnostics for the conditional logistic model
residuals_clog(mod7.3, strata = glow11m$pair, y = glow11m$fracture)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression}
(3rd ed.). John Wiley & Sons, Inc.
}
