% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ModelTermsToMap.R
\name{get_ModelTermsToMap}
\alias{get_ModelTermsToMap}
\title{Get Model Terms to Map}
\usage{
get_ModelTermsToMap(PMLParametersSets)
}
\arguments{
\item{PMLParametersSets}{An object of class "PMLModels" containing PML model
parameters.}
}
\value{
A list with two elements: "Required" and
"Optional," representing the model terms that can be mapped.
}
\description{
This function retrieves the model terms that can be mapped from a set of PML
models.
}
\examples{
# Load your PMLModels object
PMLParametersSets <-
  create_ModelPK(
    Absorption = c("First-Order", "Weibull"),
    CObs = Observation(
      ObservationName = "CObs",
      BQL = TRUE),
    A1 = Dosepoint(
      DosepointName = "A1",
      rate = StParm(StParmName = "Rate")),
    Weight = Covariate(
      Name = "Weight",
      Center = "Median")
)

# Get the model terms to map
terms_to_map <- get_ModelTermsToMap(PMLParametersSets)
print(terms_to_map$Required)
print(terms_to_map$Optional)

}
\seealso{
\code{\link[=create_ModelPK]{create_ModelPK()}} \code{\link[=create_ModelPD]{create_ModelPD()}} \code{\link[=create_CustomSpace]{create_CustomSpace()}}
}
\keyword{NLME}
