% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_Observation.R
\name{remove_Observation}
\alias{remove_Observation}
\title{Remove Observation from PML models}
\usage{
remove_Observation(PMLParametersSets, ObservationName, PMLStructures = NULL)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{ObservationName}{A character string giving the name of the Observation.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures from which the observation will be removed. For the naming
convention of PMLStructures, see Details section of
\code{\link[=create_ModelPK]{create_ModelPK()}} for PK models and \code{\link[=create_ModelPD]{create_ModelPD()}} for PD models.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Remove Observation from PML models
}
\details{
The current functionality does not support modifying custom
observations that are defined within the PML code of custom model spaces.
}
\examples{
PMLParametersSets <-
  create_ModelPK(
    CompartmentsNumber = c(2, 3),
    Parameterization = "Micro",
    Absorption = c("First-Order", "Gamma"),
    ByVector = TRUE,
    ClosedForm = TRUE,
    EliminationCpt = TRUE)

remove_Observation(PMLParametersSets,
                   ObservationName = "A0Obs",
                   PMLStructures = "PK3GME")

}
\seealso{
\code{\link[=list_Observations]{list_Observations()}}

Functions used for Observation specification: 
\code{\link{Observation}()},
\code{\link{ObservationCustom}()},
\code{\link{Sigmas}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Observation}()}
}
\concept{Observations}
