% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyByRouteCategory.R
\name{stratifyByRouteCategory}
\alias{stratifyByRouteCategory}
\title{Stratify a codelist by route category.}
\usage{
stratifyByRouteCategory(
  x,
  cdm,
  nameStyle = "{codelist_name}_{route_category}",
  keepOriginal = FALSE
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{nameStyle}{Naming of the new codelists, use \code{{codelist_name}} to
include the codelist name and \code{{route_category}} to include the route
category name.}

\item{keepOriginal}{Whether to keep the original codelist (TRUE) or just return
the stratified ones (FALSE).}
}
\value{
The codelist with the required stratifications, as different elements
of the list.
}
\description{
Stratify a codelist by route category.
}
\examples{
\donttest{
library(CodelistGenerator)
library(omopgenerics)
cdm <- mockVocabRef()
codes <- newCodelist(list("concepts" = c(20,21,22)))
new_codes <- stratifyByRouteCategory(x = codes,
                                     cdm = cdm,
                                     keepOriginal = TRUE)
new_codes
}
}
