% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{plot.coxres}
\alias{plot.coxres}
\title{Performs Cox Proportional Hazard model plots}
\usage{
\method{plot}{coxres}(x, df, plot_options, a_n = c(), ...)
}
\arguments{
\item{x}{result object from a regression, class coxres}

\item{df}{a data.table containing the columns of interest}

\item{plot_options}{list of parameters controlling the plot options, see RunCoxPlots() for different options}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}

\item{...}{can include the named entries for the plot_options parameter}
}
\value{
saves the plots in the current directory and returns the data used for plots
}
\description{
\code{plot.coxres} uses user provided data, time/event columns,
vectors specifying the model, and options to choose and save plots
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0),
  "a" = c(0, 1, 1, 0, 1, 0, 1),
  "b" = c(1, 1.1, 2.1, 2, 0.1, 1, 0.2),
  "c" = c(10, 11, 10, 11, 12, 9, 11),
  "d" = c(0, 0, 0, 1, 1, 1, 1)
)
control <- list(
  "ncores" = 1, "lr" = 0.75, "maxiters" = c(1, 1),
  "halfmax" = 1
)
formula <- Cox(Starting_Age, Ending_Age, Cancer_Status) ~
  loglinear(a, b, c, 0) + plinear(d, 0) + multiplicative()
res <- CoxRun(formula, df,
  control = control,
  a_n = list(c(1.1, -0.1, 0.2, 0.5), c(1.6, -0.12, 0.3, 0.4))
)
plot_options <- list(
  "type" = c("surv", paste(tempfile(),
    "run",
    sep = ""
  )), "studyid" = "UserID",
  "verbose" = FALSE
)
res_plot <- plot(res, df, plot_options)
}
\seealso{
Other Plotting Wrapper Functions: 
\code{\link{plotMartingale.coxres}()},
\code{\link{plotRisk.coxres}()},
\code{\link{plotSchoenfeld.coxres}()},
\code{\link{plotSurvival.coxres}()}
}
\concept{Plotting Wrapper Functions}
