% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{Itarget1}
\alias{Itarget1}
\alias{Itarget2}
\alias{Itarget3}
\alias{Itarget4}
\title{Incremental Index Target MP}
\usage{
Itarget1(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0, Imulti = 1.5)

Itarget2(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0, Imulti = 2)

Itarget3(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0, Imulti = 2.5)

Itarget4(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.3, Imulti = 2.5)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which the average index is calculated.}

\item{xx}{Parameter controlling the fraction of mean catch to start using in
first year}

\item{Imulti}{Parameter controlling how much larger target CPUE / index is
compared with recent levels.}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
A management procedure that incrementally adjusts the TAC (starting from
reference level that is a fraction of mean recent catches)
to reach a target CPUE / relative abundance index
}
\details{
Four index/CPUE target MPs proposed by Geromont and Butterworth 2014.
Tested by Carruthers et al. 2015.

The TAC is calculated as:
If  \eqn{I_\textrm{recent} \geq I_0}:
\deqn{\textrm{TAC}= 0.5 \textrm{TAC}^* \left[1+\left(\frac{I_\textrm{recent} - I_0}{I_\textrm{target} - I_0}\right)\right]}

else:
\deqn{\textrm{TAC}= 0.5 \textrm{TAC}^* \left[\frac{I_\textrm{recent}}{I_0}^2\right]}

where \eqn{I_0} is \eqn{0.8 I_{\textrm{ave}}} (the average index over the 2 x \code{yrsmth} years prior to the projection period),
\eqn{I_\textrm{recent}} is the average index over the past \code{yrsmth} years, and
\eqn{I_\textrm{target}} is \code{Imulti} times \eqn{I_{\textrm{ave}}},
and \eqn{\textrm{TAC}^*} is:
\deqn{(1-x)C}
where \eqn{x} is argument \code{xx} and C is the average catch over the last 5 years of the historical period.
}
\section{Functions}{
\itemize{
\item \code{Itarget1()}: The less precautionary TAC-based MP

\item \code{Itarget2()}: Increasing biologically precautionary TAC-based MP

\item \code{Itarget3()}: Increasing biologically precautionary TAC-based MP

\item \code{Itarget4()}: The most biologically precautionary TAC-based MP

}}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{Itarget1}: Cat, Ind, LHYear, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/Itarget1.html}{Online Documentation} for correctly rendered equations
}

\examples{
Itarget1(1, MSEtool::Atlantic_mackerel, plot=TRUE)
Itarget2(1, MSEtool::Atlantic_mackerel, plot=TRUE)
Itarget3(1, MSEtool::Atlantic_mackerel, plot=TRUE)
Itarget4(1, MSEtool::Atlantic_mackerel, plot=TRUE)
}
\references{
Carruthers et al. 2015. Performance evaluation of simple
management procedures. ICES J. Mar Sci. 73, 464-482.

Geromont, H.F., Butterworth, D.S. 2014. Generic management procedures for
data-poor fisheries; forecasting with few data. ICES J. Mar. Sci. 72, 251-261.
doi:10.1093/icesjms/fst232
}
\seealso{
Other Index methods: 
\code{\link{GB_slope}()},
\code{\link{GB_target}()},
\code{\link{Gcontrol}()},
\code{\link{ICI}()},
\code{\link{Iratio}()},
\code{\link{Islope1}()},
\code{\link{Itarget1_MPA}()},
\code{\link{ItargetE1}()}
}
\author{
T. Carruthers
}
\concept{Index methods}
