% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_errors.R
\name{calculate_errors}
\alias{calculate_errors}
\title{calculate_errors Function}
\usage{
calculate_errors(data, A, D)
}
\arguments{
\item{data}{Matrix of SFM data.}

\item{A}{Matrix of true factor loadings.}

\item{D}{Matrix of true uniquenesses.}
}
\value{
A named vector containing:
\item{MSEA}{Mean Squared Error for factor loadings.}
\item{MSED}{Mean Squared Error for uniqueness estimates.}
\item{LSA}{Relative error for factor loadings.}
\item{LSD}{Relative error for uniqueness estimates.}
}
\description{
This function calculates the Mean Squared Error (MSE) and relative error for factor loadings and uniqueness estimates obtained from factor analysis.
}
\examples{
set.seed(123) # For reproducibility
# Define dimensions
n <- 10  # Number of samples
p <- 5   # Number of factors

# Generate matrices with compatible dimensions
A <- matrix(runif(p * p, -1, 1), nrow = p)  # Factor loadings matrix (p x p)
D <- diag(runif(p, 1, 2))  # Uniquenesses matrix (p x p)
data <- matrix(runif(n * p), nrow = n)  # Data matrix (n x p)

# Calculate errors (only if SOPC is installed)
if (requireNamespace("SOPC", quietly = TRUE)) {
  errors <- calculate_errors(data, A, D)
  print(errors)
}
}
