% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.compare.R
\name{network.compare}
\alias{network.compare}
\title{Compares Network Structures Using Permutation}
\usage{
network.compare(
  base,
  comparison,
  corr = c("auto", "cor_auto", "pearson", "spearman"),
  na.data = c("pairwise", "listwise"),
  model = c("BGGM", "glasso", "TMFG"),
  iter = 1000,
  ncores,
  verbose = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{base}{Matrix or data frame.
Should consist only of variables to be used in the analysis.
First dataset}

\item{comparison}{Matrix or data frame.
Should consist only of variables to be used in the analysis.
Second dataset}

\item{corr}{Character (length = 1).
Method to compute correlations.
Defaults to \code{"auto"}.
Available options:

\itemize{

\item \code{"auto"} --- Automatically computes appropriate correlations for
the data using Pearson's for continuous, polychoric for ordinal,
tetrachoric for binary, and polyserial/biserial for ordinal/binary with
continuous. To change the number of categories that are considered
ordinal, use \code{ordinal.categories}
(see \code{\link[EGAnet]{polychoric.matrix}} for more details)

\item \code{"cor_auto"} --- Uses \code{\link[qgraph]{cor_auto}} to compute correlations.
Arguments can be passed along to the function

\item \code{"pearson"} --- Pearson's correlation is computed for all
variables regardless of categories

\item \code{"spearman"} --- Spearman's rank-order correlation is computed
for all variables regardless of categories

}

For other similarity measures, compute them first and input them
into \code{data} with the sample size (\code{n})}

\item{na.data}{Character (length = 1).
How should missing data be handled?
Defaults to \code{"pairwise"}.
Available options:

\itemize{

\item \code{"pairwise"} --- Computes correlation for all available cases between
two variables

\item \code{"listwise"} --- Computes correlation for all complete cases in the dataset

}}

\item{model}{Character (length = 1).
Defaults to \code{"glasso"}.
Available options:

\itemize{

\item \code{"BGGM"} --- Computes the Bayesian Gaussian Graphical Model.
Set argument \code{ordinal.categories} to determine
levels allowed for a variable to be considered ordinal.
See \code{?BGGM::estimate} for more details

\item \code{"glasso"} --- Computes the GLASSO with EBIC model selection.
See \code{\link[EGAnet]{EBICglasso.qgraph}} for more details

\item \code{"TMFG"} --- Computes the TMFG method.
See \code{\link[EGAnet]{TMFG}} for more details

}}

\item{iter}{Numeric (length = 1).
Number of permutations to perform.
Defaults to \code{1000} (recommended)}

\item{ncores}{Numeric (length = 1).
Number of cores to use in computing results.
Defaults to \code{ceiling(parallel::detectCores() / 2)} or half of your
computer's processing power.
Set to \code{1} to not use parallel computing}

\item{verbose}{Boolean (length = 1).
Should progress be displayed?
Defaults to \code{TRUE}.
Set to \code{FALSE} to not display progress}

\item{seed}{Numeric (length = 1).
Defaults to \code{NULL} or random results.
Set for reproducible results.
See \href{https://r-ega.net/articles/reproducibility-prng.html}{Reproducibility and PRNG}
for more details on random number generation in \code{\link{EGAnet}}}

\item{...}{Additional arguments that can be passed on to
\code{\link[EGAnet]{auto.correlate}},
\code{\link[EGAnet]{network.estimation}},
\code{\link[EGAnet]{community.detection}},
\code{\link[EGAnet]{community.consensus}},
\code{\link[EGAnet]{EGA}}, and
\code{\link[EGAnet]{jsd}}}
}
\value{
Returns a list:

\item{network}{Data frame with row names of each measure, empirical value (\code{statistic}), and
\emph{p}-value based on the permutation test (\code{p.value})}

\item{edges}{List containing matrices of values for empirical values (\code{statistic}),
\emph{p}-values (\code{p.value}), and Benjamini-Hochberg corrected \emph{p}-values (\code{p.adjusted})}
}
\description{
A permutation implementation to determine statistical
significance of whether the network structures are different from one another
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Set groups (if necessary)
groups <- rep(1:2, each = nrow(wmt) / 2)

# Groups
group1 <- wmt[groups == 1,]
group2 <- wmt[groups == 2,]

\dontrun{# Perform comparison
results <- network.compare(group1, group2)

# Print results
print(results)

# Plot edge differences
plot(results)}

}
\references{
\strong{Frobenius Norm} \cr
Ulitzsch, E., Khanna, S., Rhemtulla, M., & Domingue, B. W. (2023).
A graph theory based similarity metric enables comparison of subpopulation psychometric networks.
\emph{Psychological Methods}.

\strong{Jensen-Shannon Similarity (1 - Distance)} \cr
De Domenico, M., Nicosia, V., Arenas, A., & Latora, V. (2015).
Structural reducibility of multilayer networks.
\emph{Nature Communications}, \emph{6}(1), 1–9.

\strong{Total Network Strength} \cr
van Borkulo, C. D., van Bork, R., Boschloo, L., Kossakowski, J. J., Tio, P., Schoevers, R. A., Borsboom, D., & Waldorp, L. J. (2023).
Comparing network structures on three aspects: A permutation test.
\emph{Psychological Methods}, \emph{28}(6), 1273–1285.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
