% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milkloss_detect.R
\name{milkloss_detect}
\alias{milkloss_detect}
\title{Identify milk loss events and resilience indicators from daily milk yields}
\usage{
milkloss_detect(
  data,
  id_col,
  dim_col,
  MY_col = "MY_real",
  MY_pred,
  dim_start = 1L,
  dim_end = 305L,
  rec_mode = c("pctbase", "band", "resid"),
  drop_pct = 0.1,
  min_len = 1L,
  tol = 0.05,
  stick = 3L,
  rec = 1
)
}
\arguments{
\item{data}{A data frame containing the observed and predicted daily milking records.}

\item{id_col}{The name of the column containing the individual IDs.}

\item{dim_col}{The name of the column containing the days in milk.}

\item{MY_col}{The name of the column containing the observed milk yield.}

\item{MY_pred}{The name of the column containing the predicted milk yield (baseline).}

\item{dim_start}{The first day in milk to consider when identifying milk loss events and resilience indicators.}

\item{dim_end}{The last day in milk to consider when identifying milk loss events and resilience indicators.}

\item{rec_mode}{How "recovery" is defined. One of:
"pctbase": recovery when the observed value reaches a given fraction of the baseline (\code{rec}), for a given number of consecutive days (\code{stick});
"band": recovery when the observation is inside a tolerance band around the baseline (+/- \code{tol}), for at least \code{stick} consecutive days;
"resid": recovery when the residual has improved enough from the nadir (by a fraction \code{rec} of the nadir's absolute residual) for \code{stick} consecutive days.}

\item{drop_pct}{Minimum relative drop from the anchor (baseline reference) to accept an episode.}

\item{min_len}{Minimum number of consecutive days with negative residuals required to define an episode.}

\item{tol}{Used when the "band" mode is selected. Half-width of the tolerance band around baseline in relative terms.}

\item{stick}{Minimum number of consecutive days in recovery to consider an episode finished.}

\item{rec}{Minimum relative recovery from the nadir to finish an episode (used in "pctbase" and "resid" modes).}
}
\value{
A list with two data frames:
\itemize{
  \item \code{episodes}: individual milk loss events and their resilience indicators;
  \item \code{aggregates}: milk loss events aggregated per individual.
}
The resilience indicators identified are described in the Details section.
}
\description{
Identify milk loss events and resilience indicators from daily milk yields
}
\details{
The function computes several descriptors of milk-yield perturbation episodes.

\strong{1) Nadir (day of minimum)}

The worst day inside the episode (deepest point of the perturbation).

\code{t_hat = argmin_{t in [t_start, t_end]} obs(t)}

\code{Nadir = obs(t_hat)}

where \code{t_start} and \code{t_end} are the episode boundaries.

\strong{2) Amplitude (drop)}

Depth of the dip relative to the baseline at the episode start.

\code{A = baseline(t_start) - obs(t_hat)}

Some variants use \code{baseline(t_hat)} instead of \code{baseline(t_start)}; here the
start of the episode is used as the reference.

\strong{3) ML_per_event (AUD)}

Total milk lost (in baseline units) over the episode, i.e., the integrated milk deficit.

\code{ML_per_event = AUD = sum_{t=t_start..t_end} [baseline(t) - obs(t)]}

In discrete data, AUD is computed with day-weighting: each observation contributes

\code{(baseline(t) - obs(t)) * delta_days}

where \code{delta_days} is the gap to the next observed DIM (last day weight = 1).

\strong{4) Time-to-baseline (TTB)}

Time after the nadir until the profile returns to (and stays near) the baseline.

Recovery is declared when \code{obs(t)} re-enters a tolerance band around the
baseline and stays there for \code{stick} consecutive days (controlled by \code{tol} and \code{stick}).

We find the smallest \code{tau >= 0} such that for all \code{u} in the interval from
\code{t_hat + tau} to \code{t_hat + tau + stick - 1}:

\code{abs(obs(u) - baseline(u)) <= tol * baseline(u)}

Then: \code{TTB = tau}.

If this condition is never satisfied before DIM 305, \code{TTB} is set to \code{NA}
(right-censored).

\strong{5) Recovery half-life (t_1_2)}

Earliest time after nadir when half of the drop has been recovered.

With amplitude \code{A} as above, define the half-recovery level:

\code{L_half = baseline(t_start) - A / 2}

Then:

\code{t_1_2 = min{tau >= 0 : obs(t_hat + tau) >= L_half}}

\strong{6) Slopes (decline and recovery)}

Average daily change during the decline into the nadir and during early
recovery, summarizing the episode shape.

For a \code{K}-day local window:

\code{DeclineSlope = (obs(min(t_hat, t_start + K)) - obs(t_start)) / (min(t_hat, t_start + K) - t_start)}

\code{RecoverySlope = (obs(min(t_end, t_hat + K)) - obs(t_hat)) / (min(t_end, t_hat + K) - t_hat)}

\strong{7) AUC_deviation}

Trapezoidal area under the curve of the milk deficit \code{baseline(t) - obs(t)}
across the whole episode. It summarizes how much milk was lost and for how long.

Conceptually:

\code{AUC_deviation = integral_{t_start..t_end} [baseline(t) - obs(t)] dt}

In practice this is approximated via the trapezoidal rule on discrete DIMs.

\strong{8) prod_decline_slope_amp}

Product of the decline slope (anchor -> nadir) and the amplitude (anchor - nadir).
It combines speed and depth of the decline into a single indicator of how
"aggressive" the drop is.

\code{prod_decline_slope_amp = DeclineSlope * A}

\strong{9) prod_recovery_slope_TTB}

Product of the recovery slope (nadir -> recovery) and time-to-baseline (TTB).
It combines how fast the animal recovers with how long recovery takes,
summarizing recovery efficiency.

\code{prod_recovery_slope_TTB = RecoverySlope * TTB}
}
