#------------------------------------------------------------------------------
# Load required packages

#require(OpenMx)


#------------------------------------------------------------------------------
# Read in data

#setwd('./Projects/OpenMx/StateSpaceModel/')

#ds <- read.table('varma53.txt', header=TRUE)
#ds <- ds[,1:3]

## # Check VAR models
## m1 <- emxVARMAModel(model=c(1, 0), data=ds)
## m2 <- emxVARMAModel(model=c(2, 0), data=ds)
## m3 <- emxVARMAModel(model=c(3, 0), data=ds)
## # m3$A$values
## # m3$A$labels

## # Check VMA models
## m4 <- emxVARMAModel(model=c(0, 1), data=ds)
## m5 <- emxVARMAModel(model=c(0, 2), data=ds)
## m6 <- emxVARMAModel(model=c(0, 3), data=ds)
## # m6$A$values
## # m6$A$labels

## # Check VARMA models
## m7 <- emxVARMAModel(model=c(1, 4), data=ds)
## m8 <- emxVARMAModel(model=c(4, 1), data=ds)
## # m7$A$values; m7$labels
## # m8$A$labels; m8$A$labels

## # Check white noise model AKA VARMA(0, 0)
## m9 <- emxVARMAModel(model=c(0, 0), data=ds)
## # m9$A$values
## # m9$A$labels


## nds <- mxGenerateData(m6, nrows=1000)

## head(nds)
## dim(nds)
## plot(nds[,1], type='l')
## plot(nds[,2], type='l')
## plot(nds[,3], type='l')

## acf(nds[,1])

#------------------------------------------------------------------------------


emxVARMAModel <- function(model, data, name, run=FALSE, use=colnames(data)){
    #-------------------------------------------------------
    # General Setup
    
    #manifest and latent variable names
    manNames <- use
    latNames <- paste0('Lat', use)
    
    xdim <- length(manNames) #number of latent variables
    udim <- 1 #number of covariates
    ydim <- xdim #number of observed variables
    
    arlag <- model[1] # autoregressive lag
    malag <- model[2] #0 or 3 # moving average lag
    
    maxlag <- max(c(arlag, malag+1))
    blockxdim <- xdim*(maxlag+1)
    
    #-------------------------------------------------------
    # Block Matrix Setup
    Ix <- diag(1, nrow=xdim)
    Zx <- matrix(0, xdim, xdim)
    Lx <- outer(manNames, manNames, paste, sep='_')
    Nx <- matrix(NA, xdim, xdim)
    
    # list of autoregressive matrices with random start values
    Alist <- list()
    Alabl <- list()
    for(i in 0:(maxlag-1)){
        if(i < arlag){
            Alist[[i+1]] <- matrix(runif(xdim*xdim, -1, 1), xdim, xdim)
            Alabl[[i+1]] <- matrix(paste0('ar', i+1, '_', Lx), xdim, xdim)
        } else {
            Alist[[i+1]] <- Zx
            Alabl[[i+1]] <- Nx
        }
    }
    
    # list of moving average matrices with random start values
    Mlist <- list()
    Mlabl <- list()
    if(malag > 0){
        for(i in 0:(maxlag-2)){
            if(i < malag){
                Mlist[[i+1]] <- matrix(runif(xdim*xdim, -1, 1), xdim, xdim)
                Mlabl[[i+1]] <- matrix(paste0('ma', i+1, '_', Lx), xdim, xdim)
            } else {
                Mlist[[i+1]] <- Zx
                Mlabl[[i+1]] <- Nx
            }
        }
    } else {
        for(i in 0:(maxlag-2)){
            if(i >= 0){
                Mlist[[i+1]] <- Zx
                Mlabl[[i+1]] <- Nx
            } else {
                Mlist[[1]] <- matrix(, xdim, 0)
                Mlabl[[1]] <- matrix(, xdim, 0)
            }
        }
    }
        
    # Build AR and MA matrices into needed block
    #  state space dynamics A matrix
    Afull <- c(Alist, list(Zx))
    Mfull <- c(list(Ix), Mlist, list(Zx))
    
    arBlock <- do.call(cbind, Afull)
    maBlock <- do.call(cbind, Mfull)
    idBlock <- cbind(
        diag(1, nrow=(maxlag-1)*xdim),
        matrix(0, nrow=(maxlag-1)*xdim, ncol=2*xdim))
    
    Ablock <- rbind(arBlock, idBlock, maBlock)
    
    AfullLab <- c(Alabl, list(Nx))
    MfullLab <- c(list(Nx), Mlabl, list(Nx))
    arBlockLab <- do.call(cbind, AfullLab)
    maBlockLab <- do.call(cbind, MfullLab)
    idBlockLab <- matrix(NA, nrow=nrow(idBlock), ncol=ncol(idBlock))
    AblockLab <- rbind(arBlockLab, idBlockLab, maBlockLab)
    
    #-------------------------------------------------------
    # Starting values and more block matrices
    
    # starting factor loadings
    #  1s and 0s are assumed fixed
    startLoads <- diag(1, ydim)
    
    # starting factor variances and initial means
    # 1s and 0s are assumed fixed
    startVar <- diag(runif(xdim, 1.1, 1.8), xdim)
    startMean <- matrix(0, xdim, 1)
    
    Qblock <- matrix(0, nrow=blockxdim, ncol=blockxdim)
    Qblock[1:xdim, 1:xdim] <- startVar
    Qlab <- matrix(NA, nrow=blockxdim, ncol=blockxdim)
    diag(Qlab)[1:xdim] <- paste0('v_', manNames)
    Cblock <- matrix(0, nrow=ydim, ncol=blockxdim)
    Cblock[ , (blockxdim-xdim+1):blockxdim] <- startLoads
    
    cdimnames <- list(manNames,
                      c(paste(
                          latNames, "_lag",
                          rep(1:maxlag, each=xdim), sep=""),
                        latNames))
    
    #-------------------------------------------------------
    # OpenMx Matrix and Model Specification
    
    A <- mxMatrix("Full", blockxdim, blockxdim, values=Ablock,
                  free=(Ablock!=0 & Ablock!=1), name='A', lbound=-3, ubound=3,
                  labels=AblockLab)
    B <- mxMatrix("Zero", blockxdim, udim, name='B')
    C <- mxMatrix("Full", ydim, blockxdim, values=Cblock,
                  free=(Cblock!=0 & Cblock!=1), name='C', ubound=10,
                  dimnames=cdimnames)
    D <- mxMatrix("Full", ydim, udim, free=TRUE,
                  labels=paste0('i_', manNames), name='D')
    Q <- mxMatrix("Symm", blockxdim, blockxdim, values=vech(Qblock), labels=Qlab,
                  free=(Qblock!=0 & Qblock!=1), name='Q', lbound=0, ubound=10)
    R <- mxMatrix("Zero", ydim, ydim, name='R')
    x0 <- mxMatrix("Full", blockxdim, 1, values=startMean, free=FALSE, name='x0')
    P0 <- mxMatrix("Symm", blockxdim, blockxdim, values=diag(1, blockxdim), name='P0')
    u <- mxMatrix("Unit", udim, 1, name='u')
    
    #-------------------------------------------------------
    # Make Model
    
    nameVARMA <- paste0('VARMA(', arlag, ", ", malag, ")")
    model <- mxModel(
        name=nameVARMA,
        A, B, C, D, Q, R, x0, P0, u,
        mxData(observed=data, type='raw'),
        mxExpectationStateSpace(A='A', B='B', C='C', D='D', Q='Q', R='R',
                                x0='x0', P0='P0', u='u'),
        mxFitFunctionML()
    )
    if(run) model <- mxRun(model)
    return(model)
}

emxModelVARMA <- emxVARMAModel





#------------------------------------------------------------------------------


#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# Inspect model

#summary(runVARMA)


# Check that the dynamics are stable
# If the complex magnitude (i.e., Mod) of the eigenvalues are less than 1
#  then the dynamics are stable.
#Mod(eigen(mxEval(A, runVARMA))$values)
# Looks good.

