% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{generate_report}
\alias{generate_report}
\title{Generate Analysis Report}
\usage{
generate_report(
  results,
  output_file,
  format = c("markdown", "html", "latex"),
  title = "Empirical Dynamics Analysis Report",
  author = "EmpiricalDynamics",
  include_plots = TRUE
)
}
\arguments{
\item{results}{List containing analysis results with elements:
\itemize{
\item data: Original data frame
\item derivatives: Computed derivatives
\item exploration: Results from \code{explore_dynamics}
\item equation: Best fitted equation
\item sde: SDE model (optional)
\item validation: Results from \code{validate_model}
}}

\item{output_file}{Path for output file (required, no default to comply with CRAN policy).}

\item{format}{Report format: "markdown", "html", "latex".}

\item{title}{Report title.}

\item{author}{Author name.}

\item{include_plots}{Include diagnostic plots.}
}
\value{
Path to generated report.
}
\description{
Creates a comprehensive report of the entire analysis workflow.
}
\examples{
\donttest{
# Toy example to demonstrate report generation
# Using a temporary file to avoid writing to user's working directory
tmp_file <- tempfile("report_example")

# Mock results object
mock_results <- list(
  data = data.frame(time = 1:10, Z = runif(10)),
  equation = stats::lm(Z ~ time, data = data.frame(time = 1:10, Z = runif(10)))
)

# Generate report
report_path <- generate_report(mock_results, output_file = tmp_file, format = "markdown")
if(file.exists(report_path)) unlink(report_path)
}
}
