% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fars_methods.R
\name{predict.fars}
\alias{predict.fars}
\title{Predict Method for \code{fars} Object}
\usage{
\method{predict}{fars}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{fars}.}

\item{newdata}{A matrix or data frame with one column for the lagged dependent variable
and \code{r} columns for the factors (same \code{r} used in \code{compute_fars()}).}

\item{...}{Additional arguments (ignored).}
}
\value{
A numeric matrix with one column per quantile level and one row per observation in \code{newdata}.
}
\description{
Computes predictions from all quantile regressions in a \code{fars} object.
\code{newdata} must contain (in this order) the lagged dependent variable column
followed by the factor columns. Column names are generated internally as
\code{LagY}, \code{F1}, \code{F2}, ..., \code{Fr}.
}
