% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datSumTreeDom.R
\name{datSumTreeDom}
\alias{datSumTreeDom}
\title{Data - Aggregates numeric tree data by tree domain (i.e. species) to plot or
condition-level.}
\usage{
datSumTreeDom(
  tree = NULL,
  seed = NULL,
  cond = NULL,
  plt = NULL,
  subp_cond = NULL,
  subplot = NULL,
  datsource = "obj",
  dbconn = NULL,
  dsn = NULL,
  bycond = FALSE,
  bysubp = FALSE,
  tsumvar = NULL,
  seedlings = "N",
  woodland = "Y",
  tfilter = NULL,
  tdomvar = "SPCD",
  tdomvarlst = NULL,
  tdomvar2 = NULL,
  tdomvar2lst = NULL,
  tdomprefix = NULL,
  tdombarplot = FALSE,
  tdomtot = FALSE,
  tdomtotnm = NULL,
  bydomainlst = NULL,
  FIAname = FALSE,
  spcd_name = "COMMON",
  pivot = TRUE,
  presence = FALSE,
  proportion = FALSE,
  getadjplot = FALSE,
  domclassify = NULL,
  tderive = NULL,
  pltidsWITHqry = NULL,
  pltidsid = NULL,
  pcwhereqry = NULL,
  savedata = FALSE,
  tabIDs = tableIDs(),
  datSum_opts = datSum_options(),
  database_opts = NULL,
  savedata_opts = NULL
)
}
\arguments{
\item{tree}{Data frame or comma-delimited file (*.csv). The tree-level table
with tree domain data.}

\item{seed}{Data frame or comma-delimited file (*.csv). The seedling table
with tree seedling counts. Only applicable for counts (tsumvar="PLT_CN").}

\item{cond}{Data frame or comma-delimited file (*.csv). Condition-level
table to join the aggregated tree data to, if bycond=TRUE. This table also
may be used for condition proportion or strata variables used if adjcond or
adjstrata = TRUE (See details below).  This table is optional. If included,
CONDID must be present in table.}

\item{plt}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Plot-level table to join the aggregated tree data to, if bycond=FALSE. This
table is optional.}

\item{subp_cond}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Subplot condition-level table to use to sum condition proportions, 
if bysubp=TRUE.}

\item{subplot}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Subplot-level table to used to calculate adjustment factors, to remove 
nonsampled conditions (SUBP_STATUS_CD = 3). This table is optional.}

\item{datsource}{String. Source of data ('obj', 'csv', 'sqlite', 'gdb').}

\item{dbconn}{Open database connection.}

\item{dsn}{String. If datsource='sqlite', the name of SQLite database
(*.sqlite).}

\item{bycond}{Logical. If TRUE, data are aggregated to the condition level
(by: uniqueid, CONDID). If FALSE, data are aggregated to the plot level (by:
uniqueid).}

\item{bysubp}{Logical. If TRUE, data are aggregated to the subplot level.}

\item{tsumvar}{String. Name of the variable to aggregate (e.g., "BA"). For
summing number of trees, use tsumvar="TPA_UNADJ" with tfun=sum.}

\item{seedlings}{String. ('Y', 'N', 'only') If seedlings = 'Y', add
seedlings to summary ('TPA_UNADJ' %in% tsumvarlst). If seedlings = 'N',
do not add seedlings. If seedlings = 'only', only include seedlings.}

\item{woodland}{String. ('Y', 'N', 'only') If woodland = 'Y', include
woodland tree species where measured. If woodland = 'N', only include 
timber species. See FIESTA::ref_species$WOODLAND ='Y/N'. If woodland = 'only', 
only include woodland species. If NULL, use whatever is in table.}

\item{tfilter}{String. A filter to subset the tree data before aggregating
(e.g., "STATUSCD == 1"). This must be in R syntax. If tfilter=NULL, user is
prompted.  Use tfilter="NONE" if no filters.}

\item{tdomvar}{String. The tree domain (tdom) variable used to aggregate by
(e.g., "SPCD", "SPGRPCD").}

\item{tdomvarlst}{String (vector). List of specific tree domains of tdomvar
to aggregate (e.g., c(108, 202)). If NULL, all domains of tdomvar are used.}

\item{tdomvar2}{String. A second tree domain variable to use to aggregate by
(e.g. "DIACL").  The variables, tdomvar and tdomvar2 will be concatenated
before summed.}

\item{tdomvar2lst}{String (vector). List of specific tree domains of
tdomvar2 to aggregate.  If NULL, all domains of tdomvar2 are used.}

\item{tdomprefix}{String. The prefix used for naming the aggregated tree
data, before numeric codes (e.g., "SP" = SP102, SP746).}

\item{tdombarplot}{Logical. If TRUE and pivot=TRUE, calls datBarplot() and
outputs a barplot of tdom distributions. If savedata=TRUE, barplots are
written to outfolder.}

\item{tdomtot}{Logical. If TRUE and pivot=TRUE a total of all tree domains
in tdomvarlst is calculated and added to output data frame.}

\item{tdomtotnm}{String. If tdomtot=TRUE, the variable name for the total
column in output data frame. If NULL, the default will be tdomvar + 'TOT'.}

\item{bydomainlst}{String (vector). Categorical domain variables not in
tdomvar/tdomvar2. Variables must be in tree table or plt/cond table if tables 
are provided.}

\item{FIAname}{Logical. If TRUE, changes names of columns for SPCD and
SPGRPCD from code to FIA names.}

\item{spcd_name}{String. Output name type if tdomvar or tdomvar2 = "SPCD"
('COMMON', 'SCIENTIFIC', 'SYMBOL').}

\item{pivot}{Logical. If TRUE, tdomvar data are transposed (pivoted) to
separate columns.}

\item{presence}{Logical. If TRUE, an additional table is output with tree
domain values as presence/absence (1/0).}

\item{proportion}{Logical. If TRUE and pivot=TRUE, an additional table will
be output with tree domain data as proportions of total tsumvar.}

\item{getadjplot}{Logical. If TRUE, adjustments are calculated for
nonsampled conditions on plot.}

\item{domclassify}{List. List for classifying domain variables in bydomainlst
(e.g., DIA = c(10,20,30)).}

\item{tderive}{List. List of derivative to add to output data (e.g., 
list(MEAN_DIA = 'AVG(DIA)', SDI = 'POWER(DIA / 10, 1.605)', 
QMD = 'SQRT(SUM(POWER(DIA,2) * 0.005454 * TPA_UNADJ) / (SUM(TPA_UNADJ)*0.005454))'))}

\item{pltidsWITHqry}{SQL query. A query identifying plots to sum (e.g., 
'WITH pltids AS (SELECT cn AS PLT_CN FROM plot WHERE statecd=49 and INVYR=2018)')}

\item{pltidsid}{Sting. Name of unique identifier in pltidsWITHqry.}

\item{pcwhereqry}{String. Plot/Condition filter if plot and/or cond table is 
included.}

\item{savedata}{Logical. If TRUE, saves data to outfolder.}

\item{tabIDs}{List of unique IDs corresponding to the tables. See
See help(tableIDs) for a list of options.}

\item{datSum_opts}{List. Options for summarizing tree data, such as TPA,
rounding, and adjusting TPA. See help(datSum_options()) for a list of 
options.}

\item{database_opts}{List. Options for database, such as schema and 
password. See help(database_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE. If out_layer = NULL,
default = 'tdomsum'.}
}
\value{
tdomdata - a list of the following objects:

\item{tdomdat}{ Data frame. Plot or condition-level table with aggregated
tree domain (tdom) attributes (filtered). } 
\item{tdomsum}{ Data frame. The tdom look-up table with data aggregated 
by species. } 
\item{tdomvar}{ String. Name of the tdom variable used to aggregate by. }
\item{tsumvar}{ String. Name of the aggregated output variable. } 
\item{tdomlst}{ Vector. List of the aggregated tree data in tdomdat. } 
\item{tdomdat.pres}{ Data frame. Plot or condition-level table with 
aggregated tree domain attributes represented as presence/absence (1/0). } 
\item{tdomdat.prop}{ Data frame. Plot or condition-level table with 
aggregated tree domain attributes represented as proportion of total by 
plot. } 
\item{tdomdat.cov}{ Data frame. Plot or condition-level table with 
aggregated tree domain attributes represented as percent cover, multipying 
cover attribute by tdom proportion by plot. }

If savedata=TRUE\cr - tdomdat will be saved to the outfolder
('tdomprefix'_DAT.csv). \cr - a text file of input parameters is saved to
outfolder ('outfn'_parameters_'date'.txt). \cr - if presence=TRUE,
tdomdat.prop is saved to outfolder ('tdomprefix'_PRESDAT.csv) - if
proportion=TRUE, tdomdat.prop is saved to outfolder
('tdomprefix'_PROPDAT.csv) - if cover=TRUE, tdomdat.prop is saved to
outfolder ('tdomprefix'_COVDAT.csv)
}
\description{
Aggregates numeric tree domain data (e.g., SPCD) to plot or condition,
including options for filtering tree data or extrapolating to plot acre by
multiplying by TPA. Includes options for generating barplots, proportion
data, and cover data.
}
\details{
If variable = NULL, then it will prompt user for input.

If you want to get trees-per-acre information aggregated to plot or
condition level, you need to include a TPA variable in tree table. \cr For
tsumvars = GROWCFGS, GROWBFSL, GROWCFAL, FGROWCFGS, FGROWBFSL, or FGROWCFAL,
you must have TPAGROW_UNADJ \cr For tsumvars = MORTCFGS, MORTBFSL, MORTCFAL,
FMORTCFGS, FMORTBFSL, or FMORTCFAL, you must have TPAMORT_UNADJ \cr For
tsumvars = REMVCFGS, REMVBFSL, REMVCFAL, FREMVCFGS, FREMVBFSL, or FREMVCFAL,
you must have TPAREMV_UNADJ \cr

If you want to adjust plot-level information by condition proportions, you
need to include CONDID & CONDPROP_UNADJ in cond or tree table. \cr

If you want to adjust the aggregated tree data by the area of the strata
(estimation unit), you need to either have a variable in your tree data
named adjfact or you need to included the following variables in your
datasets: \cr Condition table: STATECD, CONDID, STRATA, ESTUNIT,
SUBPPROP_UNADJ, MICRPROP_UNADJ (if microplot trees) MACRPROP_UNADJ (if
macroplot trees). \cr Tree table: TPA_UNADJ

All trees where DIA=NA are removed from analysis. These are trees that were
remeasured but are no longer in inventory (ex. a tree that is dead and not
standing in the current inventory).
}
\note{
This function can be used to get tree domain data. This data can be
used for mapping tree domain distributions.
}
\examples{
\donttest{
              
# Sum of Number of Live Trees by Species
datSumTreeDom(tree = FIESTA::WYtree,
              plt = FIESTA::WYplt, 
              bycond = FALSE, 
              tsumvar = "TPA_UNADJ", 
              tdomtot = TRUE, 
              tdomprefix = "CNT", 
              tfilter = "STATUSCD==1",
              datSum_opts = list(tround = 0))
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
