% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{Mixing_Metric}
\alias{Mixing_Metric}
\title{k-NN Mixing Metric}
\usage{
Mixing_Metric(embedding, dataset_list, k = 5, max.k = 300, seed = NULL)
}
\arguments{
\item{embedding}{Numeric matrix (n × d) where each row is the coordinates of one
sample in the low-dimensional space (PCA, UMAP, t-SNE, …).}

\item{dataset_list}{Factor or character vector of length n indicating which dataset
each sample comes from.}

\item{k}{Positive integer.  The rank of the within-dataset neighbour to look for
(default 5).}

\item{max.k}{Positive integer.  Total number of nearest neighbours to compute
(default 300).}

\item{seed}{Integer, random seed for reproducibility (optional). If NULL, uses current random state.}
}
\value{
Named numeric vector with one entry per unique level of
                       `dataset_list`.  The entry is the median position (among
                       1 … max.k) of the k-th within-dataset neighbour across all
                       samples that belong to that dataset.  Values are clamped to
                       max.k when fewer than k within-dataset neighbours exist.
}
\description{
Evaluate the degree of mixing between two or more datasets in a low-dimensional embedding.
}
