% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{phy_to_floral_data}
\alias{phy_to_floral_data}
\title{Create data input list from phyloseq object}
\usage{
phy_to_floral_data(phy, y = NULL, covariates = NULL)
}
\arguments{
\item{phy}{Phyloseq object}

\item{y}{Outcome column of interest from phy's sample_data}

\item{covariates}{Covariate column names from phy's sample_data}
}
\value{
list
}
\description{
Create data input list from phyloseq object
}
\examples{
library(phyloseq)
data(GlobalPatterns)
# add a covariate
sample_data(GlobalPatterns)$test <- rep(c(1, 0), nsamples(GlobalPatterns)/2)
# GlobalPatterns <- tax_glom(GlobalPatterns, "Phylum")
dat <- phy_to_floral_data(GlobalPatterns, y = "test", covariates = c("SampleType"))
# res <- FLORAL(x = dat$xcount, y=dat$y, ncov=dat$ncov, family = "binomial", ncv=NULL)

}
