% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Drsvd.R
\name{Drsvd}
\alias{Drsvd}
\title{Distributed Random SVD}
\usage{
Drsvd(data, K, nk, m, q, k)
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{K}{Number of distributed nodes.}

\item{nk}{Size of each subset.}

\item{m}{Target dimension for random projection.}

\item{q}{Number of power iterations.}

\item{k}{Desired rank.}
}
\value{
A vector containing MSE values and optimal subset index.
}
\description{
Distributed Random SVD
}
\examples{
library(rsvd)
library(matrixcalc)
K <- 20
nk <- 50
p <- 8
m <- 5
q <- 5
k <- 4
n <- K * nk
data <- matrix(rexp(n * p, 0.8), ncol = p)
Drsvd(data = data, K = K, nk = nk, m = m, q = q, k = k)
}
