% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{simulatedAnnealing}
\alias{simulatedAnnealing}
\title{Simulated Annealing}
\usage{
simulatedAnnealing(
  start = NULL,
  temperature = 1,
  temperature_min = 0.01,
  reduction = 0.6,
  innerIter = 1,
  verbose = FALSE
)
}
\arguments{
\item{start}{Binary vector with the set of initial features}

\item{temperature}{Temperature initial}

\item{temperature_min}{Temperature to stops in the outer loop}

\item{reduction}{Temperature reduction in the outer loop}

\item{innerIter}{Number of iterations of inner loop. By default no inner iterations are established}

\item{verbose}{Print the partial results in each iteration}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on simulated annealing. This function is called internally within the \code{\link{searchAlgorithm}} function. The simulatedAnnealing method \insertCite{KirkpatrickGelattVecchi1983}{FSinR} starts with a certain set of features and in each iteration modifies an element of the previous feature vector and decreases the temperature. If the energy of the new feature vector is better than that of the old vector, it is accepted and moved towards it, otherwise it is moved towards the new vector according to an acceptance probability.  The algorithm ends when the minimum temperature has been reached. Additionally, a number of internal iterations can be performed within each iteration of the algorithm. In this case, the same temperature value of the outer iteration is used for the inner iterations
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function with Simulated annealing
sa_search <- simulatedAnnealing()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
sa_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
