## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ForCausality)
library(ggplot2)
library(dplyr)

## ----patterns-subcortical-plot, fig.width=6, fig.height=4, out.width="100%", fig.alt = "Bar chart showing the number of patients by treatment group in the Colon_df dataset"----
# Summarize the number of patients per treatment group
colon_summary <- Colon_df %>%
  group_by(rx) %>%
  summarise(count = n())

# Create a simple bar chart
ggplot(colon_summary, aes(x = rx, y = count, fill = rx)) +
  geom_bar(stat = "identity") +
  labs(
    title = "Number of Patients by Treatment Group",
    x = "Treatment Group",
    y = "Number of Patients"
  ) +
  theme_minimal() +
  guides(fill = "none")  # Hide the legend since x-axis already shows groups

