% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_ForLion_MLM_Optimal.R
\name{EW_ForLion_MLM_Optimal}
\alias{EW_ForLion_MLM_Optimal}
\title{EW ForLion function for multinomial logit models}
\usage{
EW_ForLion_MLM_Optimal(
  J,
  n.factor,
  factor.level,
  var_names = NULL,
  xlist_fix = NULL,
  hfunc,
  h.prime,
  bvec_matrix,
  link = "continuation",
  EW_Fi.func = EW_Fi_MLM_func,
  delta0 = 1e-05,
  epsilon = 1e-12,
  reltol = 1e-05,
  delta = 0,
  maxit = 100,
  random = FALSE,
  nram = 3,
  rowmax = NULL,
  Xini = NULL,
  pini = NULL,
  random.initial = FALSE,
  nram.initial = 3,
  optim_grad = FALSE
)
}
\arguments{
\item{J}{number of response levels in the multinomial logit model}

\item{n.factor}{Vector of numbers of distinct levels, “0” indicating continuous factors that always come first, “2” or more for discrete factors, and “1” not allowed.}

\item{factor.level}{list of distinct factor levels, “(min, max)” for continuous factors that always come first, finite sets for discrete factors.}

\item{var_names}{Names for the design factors. Must have the same length asfactor.level. Defaults to "X1", "X2", ...}

\item{xlist_fix}{list of discrete factor experimental settings under consideration, default NULL indicating a list of all possible discrete factor experimental settings will be used.}

\item{hfunc}{function for generating the corresponding model matrix or predictor vector, given an experimental setting or design point.}

\item{h.prime}{User-supplied derivative function for continuous factors x_(1) in R^k (k is the number of continuous variables). For MLMs: returns a list of J*p matrices dX_x/dx_j, j=1,...,k (numerical derivatives if omitted).  For GLMs: returns the p times k matrix dh(x)/dx_(1) (defaults to main effects if omitted).}

\item{bvec_matrix}{Matrix of bootstrapped or simulated parameter values.}

\item{link}{link function, default "continuation", other choices "baseline", "cumulative", and "adjacent"}

\item{EW_Fi.func}{function to calculate entry wise expectation of Fisher information Fi, default EW_Fi_MLM_func.}

\item{delta0}{merging threshold for initial design, such that, || x_i(0) - x_j(0) || >= delta0, default 1e-5}

\item{epsilon}{tuning parameter as converging threshold, such that, a nonnegative number is regarded as numerical zero if less than epsilon, default 1e-12.}

\item{reltol}{the relative convergence tolerance, default value 1e-5}

\item{delta}{relative difference as merging threshold for the merging step, the distance of two points less than delta may be merged, default 0, can be different from delta0 for the initial design.}

\item{maxit}{the maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, whether or not to repeat the lift-one step multiple times with random initial allocations, default FALSE.}

\item{nram}{number of times repeating the lift-one step with random initial allocations, valid only if random is TRUE, default 3.}

\item{rowmax}{maximum number of points in the initial design, default NULL indicates no restriction}

\item{Xini}{initial list of design points, default NULL indicating automatically generating an initial list of design points.}

\item{pini}{A numeric vector specifying the initial weights for the design points in Xini, default NULL indicating automatically generating an uniform weights of design points.}

\item{random.initial}{TRUE or FALSE, whether or not to repeat the whole procedure multiple times with random initial designs, default FALSE.}

\item{nram.initial}{number of times repeating the whole procedure with random initial designs, valid only if random.initial is TRUE, default 3.}

\item{optim_grad}{TRUE or FALSE, default is FALSE, whether to use the analytical gradient function or numerical gradient when searching for a new design point.}
}
\value{
m           the number of design points

x.factor    matrix of experimental factors with rows indicating design point

p           the reported EW D-optimal approximate allocation

det         the determinant of the maximum Expectation of Fisher information

convergence TRUE or FALSE, whether converge

min.diff    the minimum Euclidean distance between design points

x.close     pair of design points with minimum distance

itmax       iteration of the algorithm
}
\description{
Function for EW ForLion algorithm to find EW D-optimal design under multinomial logit models with mixed factors.
Reference Section 3 of Lin, Huang, Yang (2025).
Factors may include discrete factors with finite number of distinct levels and continuous factors with specified interval range (min, max), continuous factors, if any, must serve as main-effects only, allowing merging points that are close enough.
Continuous factors first then discrete factors, model parameters should in the same order of factors.
}
\examples{
J=3
p=5
hfunc.temp = function(y){
matrix(data=c(1,y,y*y,0,0,0,0,0,1,y,0,0,0,0,0), nrow=3, ncol=5, byrow=TRUE)
} #hfunc is a 3*5 matrix, transfer x design matrix to model matrix for emergence of flies example

hprime.temp = function(y){
list(matrix_1 =matrix(data=c(0, 1, 2*y, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0),
    nrow=3, ncol=5, byrow=TRUE))
}

link.temp = "continuation"
n.factor.temp = c(0)  # 1 continuous factor no discrete factor in EW ForLion
factor.level.temp = list(c(80,200)) #boundary for continuous parameter in EW Forlion
bvec_bootstrap<-matrix(c(-0.2401, -1.9292, -2.7851, -1.614,-1.162,
                         -0.0535, -0.0274, -0.0096,-0.0291, -0.04,
                          0.0004,  0.0003,  0.0002,  0.0003,  0.1,
                         -9.2154, -9.7576, -9.6818, -8.5139, -8.56),nrow=4,byrow=TRUE)
EW_ForLion_MLM_Optimal(J=J, n.factor=n.factor.temp, factor.level=factor.level.temp,
         xlist_fix=NULL, hfunc=hfunc.temp,h.prime=h.prime.temp, bvec_matrix=bvec_bootstrap,
         reltol=1e-2, delta=1, link=link.temp, optim_grad=FALSE)

}
