% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_bavrn_state.R
\name{validate_fe_species_bavrn_state}
\alias{validate_fe_species_bavrn_state}
\title{Validate an \emph{fe_species_bavrn_state} Object}
\usage{
validate_fe_species_bavrn_state(x = character())
}
\arguments{
\item{x}{An object that is expected to be a correct
\code{fe_species_bavrn_state} object}
}
\value{
Returns \code{x}, but this function is mainly called for its side
effect which is pointing out any violations of the
\code{fe_species_bavrn_state} object specifications. In case of such
violations, the function will terminate with an error.
}
\description{
Regular users will not require this function. Expert users will want to use
it in combination with the constructor \code{\link{fe_species_bavrn_state}}.
Regular users, please construct \code{fe_species_bavrn_state} objects with
\code{\link{fe_species_bavrn_state}}.
}
\examples{
# Passes validation
spec_ids <- as.character(c(30, 30, 30, 10, 10, 10, 10, 20, 20, 80))
spec_ids <- new_fe_species_bavrn_state(spec_ids)
validate_fe_species_bavrn_state(spec_ids)

# Validating the following spec_ids throws an error due to
# non-supported species codes
spec_ids <- as.character(c(30, 30, 8712, 10, 10, 10, 349, 20, 20, 80))
spec_ids <- new_fe_species_bavrn_state(spec_ids)
try(
  validate_fe_species_bavrn_state(spec_ids)
)

}
