#' Function to performs a linear discriminant analysis (LDA) for a multivariate set of features
#'
#' @param z numeric vector of length n, with values in [0,1]
#' @param v numeric matrix nxd. Each row is an observation, each column a feature
#' @return Returns a one-dimensional discriminant score  y for each observation, computed by projecting the feature matrix v onto the first LDA direction estimated using the soft class-membership weights z.
#' @name sLDA
#' @keywords internal
sLDA <- function(z,v){
  n <- length(z)
  mu1 <- apply(v * z, 2, sum) / sum(z)
  mu0 <- apply(v * (1-z), 2, sum) / sum(1-z)
  mu <- (sum(z) * mu1 + sum(1 - z) * mu0) / n
  Sb <- 1/n*(matrix((mu0-mu),ncol=1) %*% matrix((mu0-mu),nrow=1)*sum(1-z) + matrix((mu1-mu),ncol=1) %*% matrix((mu1-mu),nrow=1) * sum(z))
  S <- 1/n*( t( z * (v - matrix(rep(mu1,n),nrow=n,byrow = T))) %*% (v - matrix(rep(mu1,n),nrow=n,byrow = T))  + t( (1-z) * (v - matrix(rep(mu0,n),nrow=n,byrow = T))) %*% (v - matrix(rep(mu0,n),nrow=n,byrow = T)) )
  r <- eigen(solve(S + 1e-9 * diag(dim(S)[1])) %*% Sb)
  lda.v <- r$vectors[,1]
  y <- as.numeric(v %*% lda.v)
  return(y)
}