% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiyw.R
\name{date_to_epiyw}
\alias{date_to_epiyw}
\title{Convert a date to epiyearweek format}
\usage{
date_to_epiyw(date, weekday = "Monday")
}
\arguments{
\item{date}{A vector of type 'Date'.}

\item{weekday}{The weekday that determines the start of the week. Defaults to
'Monday'.}
}
\value{
The transformed dates to epiyearweek.
}
\description{
The conversion is done following the ISO 8601 standard,
whereby the first week of the year is the one that contains at
least four days of the new year. This coincides with the
approach taken by \code{lubridate::epiweek} and \code{lubridate::isoweek}
but may not coincide with other definitions of epidemiological weeks.
}
\examples{
# Convert dates in 'dengue_SP' in epiyw
data(dengue_SP)
head(dengue_SP$date)
dengue_SP$epiyw <- date_to_epiyw(as.Date(dengue_SP$date), "Sunday")
head(dengue_SP$epiyw)
}
