% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ppd.R
\name{plot_ppd}
\alias{plot_ppd}
\title{Plot Posterior Predictive Densities Versus Observed Data}
\usage{
plot_ppd(
  ppd,
  xlab = "Outcome",
  ylab = "Density",
  title = "Posterior Predictive Distribution",
  xlim = NULL,
  obs_color = NULL,
  ppd_color = NULL
)
}
\arguments{
\item{ppd}{A \code{data.frame} containing posterior-predictive samples
(one column per sample) and the column with \code{observed} data.}

\item{xlab}{Character: x-axis label. Default \code{"Outcome"}.}

\item{ylab}{Character: y-axis label. Default \code{"Density"}.}

\item{title}{Character: plot title. Default
\code{"Posterior Predictive Distribution"}.}

\item{xlim}{Numeric vector of length 2 giving the minimum and maximum
x-axis values, e.g. \code{c(0, 25)}.
If \code{NULL} (default) the limits are
\code{c(0, quantile(observed, 0.95))}.}

\item{obs_color}{Color for the observed line density}

\item{ppd_color}{Color for the posterior predictive distribution lines density}
}
\value{
A \pkg{ggplot2} plot object.
}
\description{
This function draws kernel-density curves for posterior-predictive samples
and observed data using \code{ggplot2::geom_line()}.  Each predictive
sample’s density is plotted in light blue; the observed density is overlaid
in black.
}
\examples{
\donttest{
# Load example dataset
data(dengueMS)

# Declare formulas
formulas <- c("dengue_cases ~ tmin +  f(year, model='rw1')")

# Tranform formulas into a 'GHRformulas' object
ghr_formula <- as_GHRformulas(formulas)

# Fit multiple models 
results <- fit_models(
  formulas = ghr_formula,
  data     = dengue_MS[dengue_MS$year \%in\% 2005:2010,],
  family   = "nbinomial",
  name     = "model",
  offset   = "population",
  nthreads = 2,
  control_compute = list(config = FALSE),
  pb       = TRUE
)

# Generate 100 samples from the posterior predictive distribution of the model
ppd_df <- sample_ppd( 
  results,
  mod_id = "model1", 
  s = 100,
  nthreads = 2)

# Plot densities of the posterior predictive distribution and observed cases.
plot_ppd(ppd_df, obs_color = "blue", ppd_color = "red")
}

}
