% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_delete_datasets}
\alias{galaxy_delete_datasets}
\title{Delete multiple Galaxy datasets by ID}
\usage{
galaxy_delete_datasets(
  output_ids,
  purge = TRUE,
  sleep = 0.2,
  galaxy_url = "https://usegalaxy.eu"
)
}
\arguments{
\item{output_ids}{Character vector of dataset IDs to delete.}

\item{purge}{Logical. Passed to \code{galaxy_delete_dataset}. Default: \code{TRUE}.}

\item{sleep}{Numeric. Seconds to wait between API calls. Default: \code{0.2}.}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}
}
\value{
A named list where each element is the return value from
\code{galaxy_delete_dataset} for the corresponding dataset ID.
}
\description{
Convenience wrapper that deletes a vector of dataset IDs using
\code{galaxy_delete_dataset}. Requests are paced with a small
sleep between calls to avoid overwhelming the server.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
input_file <- tempfile(fileext = ".txt")
input_file2 <- tempfile(fileext = ".txt")
test_text <- "This is an example \nfile."
writeLines(test_text,input_file)
writeLines(test_text,input_file2)
history_id <- galaxy_initialize("test upload")
dataset_id <- galaxy_upload_https(input_file, history_id)
dataset_id2 <- galaxy_upload_https(input_file2, history_id)

galaxy_delete_datasets(list(output_ids = c(dataset_id, dataset_id2)))
\dontshow{\}) # examplesIf}
}
