#' Prints package startup message
#'
#' This function is only called by R when attaching the package.
#'
#' @param libname Name of library.
#' @param pkgname Name of package.
#' @return Nothing
.onAttach <- function(libname, pkgname) {

  ### Welcome message
  GowerSOMVersion <- tryCatch(utils::packageDescription("GowerSOM", fields = "Version"),
                            warning=function(w) return("alpha"),
                            error=function(e) return("alpha"))
  txt0 <- paste0("\n",
                 "\n          //////   /////   //          //   /////   /////// " ,
                 "\n        //        //   //   //        //   //       //   //  ",
                 "\n        //  ////  //   //    //  /// //   ////      ////// ",
                 "\n        //    //  //   //    // // ///    //        //   //    ",
                 "\n         //////    ////      ////  //     //////    //    //",
                 "\n   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,      ",
                 "\n         ",
                 "\n                 //////    /////     ////   // ",
                 "\n                //        //   //    // // //// ",
                 "\n                //////    //   //    // //// // ",
                 "\n                    //    //   //    // ///  // ",
                 "\n               //////      ////      //      // ",
                 "\n")

  txt1 <- paste0("\nGowerSOM ", GowerSOMVersion,
                 "\nPlease cite GowerSOM in all written material you produce:",
                 "\nSaez P, Salas P (2025). \"Gower-SOM: A Self-Organizing Map",
                 "\nfor Mixed Data with Gower Distance and Heuristic Adaptation",
                 "\nfor Data Analytics.\" Journal of Data Science and Analytics",
                 "\n32. doi.org/10.1016/j.jocm.2019.100170."
  )
  ### Print message
  ### Print message
  txt=paste0(txt0,txt1)

  txt= cli::make_ansi_style("#0097ba",bg=FALSE)(txt)
  #cat(cli::make_ansi_style("#0097ba",bg=FALSE)(txt))
  packageStartupMessage(txt)

  #if(isOld) txt=paste0(txt,txt2)
  #packageStartupMessage(txt)
  #if(isOld) Sys.sleep(5)
}
