% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_gul_loadings.R
\name{estimate_gul_loadings}
\alias{estimate_gul_loadings}
\title{General unilateral load  Estimator}
\usage{
estimate_gul_loadings(X, m)
}
\arguments{
\item{X}{n *p data matrix (already centred and scaled if desired).}

\item{m}{number of latent factors (both layers).}
}
\value{
A list with
  hat_A1  : p * m  1st-layer loadings
  hat_A2  : m * m  2nd-layer loadings
  hat_Ag  : p * m  overall loadings
  Sigma1  : p * p  sample cov(X)  (for diagnostics)
  Sigma2  : m * m  sample cov(hat_gF1)
  hat_gF1 : n * m  estimated transformed latent factors
  eig1    : eigen-values of Sigma1
  eig2    : eigen-values of Sigma2
}
\description{
General unilateral load  Estimator
}
\details{
Step 1: PCA on X  to get  hat_A1
Step 2: Regress X on hat_A1  to get  hat_gF1
Step 3: PCA on hat_gF1  to get  hat_A2
Step 4: hat_Ag = hat_A1 %*% t(hat_A2)
}
\examples{
dat  <- generate_gfm_data(500, 50, 5, tanh, seed = 1)
est  <- estimate_gul_loadings(dat$X, m = 5)
err  <- sqrt(mean((est$hat_Ag - dat$Ag)^2))  # overall RMSE
}
